/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.listener;

import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.entity.PeerId;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.hugegraph.store.HgStoreEngine;
import org.apache.hugegraph.store.node.grpc.HgStoreStreamImpl;
import org.apache.hugegraph.store.node.task.TTLCleaner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.stereotype.Service;

@Service
public class ContextClosedListener
implements ApplicationListener<ContextClosedEvent> {
    private static final Logger log = LoggerFactory.getLogger(ContextClosedListener.class);
    @Autowired
    HgStoreStreamImpl storeStream;
    @Autowired
    TTLCleaner cleaner;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void onApplicationEvent(ContextClosedEvent event) {
        try {
            ScheduledExecutorService scheduler;
            ThreadPoolExecutor executor;
            try {
                this.transferLeaders();
                Class<ContextClosedListener> clazz = ContextClosedListener.class;
                // MONITORENTER : org.apache.hugegraph.store.node.listener.ContextClosedListener.class
                ContextClosedListener.class.wait(60000L);
                // MONITOREXIT : clazz
                this.transferLeaders();
                clazz = ContextClosedListener.class;
                // MONITORENTER : org.apache.hugegraph.store.node.listener.ContextClosedListener.class
                ContextClosedListener.class.wait(30000L);
                // MONITOREXIT : clazz
            }
            catch (Exception e) {
                log.info("shutdown hook: ", (Throwable)e);
            }
            log.info("closing scan threads....");
            if (this.storeStream != null && (executor = this.storeStream.getRealExecutor()) != null) {
                try {
                    executor.shutdownNow();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.cleaner == null) return;
            ThreadPoolExecutor cleanerExecutor = this.cleaner.getExecutor();
            if (cleanerExecutor != null) {
                try {
                    cleanerExecutor.shutdownNow();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((scheduler = this.cleaner.getScheduler()) == null) return;
            try {
                scheduler.shutdownNow();
                return;
            }
            catch (Exception exception) {
                // empty catch block
                return;
            }
        }
        catch (Exception e) {
            log.error("ContextClosedListener: ", (Throwable)e);
            return;
        }
        finally {
            log.info("closed scan threads");
        }
    }

    private void transferLeaders() {
        try {
            HgStoreEngine.getInstance().getLeaderPartition().forEach(leader -> {
                try {
                    Status status = leader.getRaftNode().transferLeadershipTo(PeerId.ANY_PEER);
                    log.info("partition {} transfer leader status: {}", (Object)leader.getGroupId(), (Object)status);
                }
                catch (Exception e) {
                    log.info("partition {} transfer leader error: ", (Object)leader.getGroupId(), (Object)e);
                }
            });
            HgStoreEngine.getInstance().getPartitionEngines().forEach((integer, partitionEngine) -> partitionEngine.getRaftNode().shutdown());
        }
        catch (Exception e) {
            log.error("transfer leader failed: " + e.getMessage());
        }
    }
}

