/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.listener;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hugegraph.pd.client.KvClient;
import org.apache.hugegraph.pd.client.PDConfig;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.grpc.kv.ScanPrefixResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.yaml.snakeyaml.Yaml;

public class PdConfigureListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent> {
    private static final Logger log = LoggerFactory.getLogger(PdConfigureListener.class);
    private static final String CONFIG_PREFIX = "S:";
    private static final String CONFIG_FIX_PREFIX = "S:FS";
    private static final String TIMESTAMP_KEY = "S:Timestamp";
    private static final String PD_CONFIG_FILE_NAME = "application-pd.yml";
    private final String workDir = System.getProperty("user.dir");
    private final String fileSeparator = System.getProperty("file.separator");
    private final String configFilePath = this.workDir + this.fileSeparator + "conf" + this.fileSeparator + "application-pd.yml";
    private final String restartShellPath = this.workDir + this.fileSeparator + "bin" + this.fileSeparator + "restart-hugegraph-store.sh";
    private ConfigurableApplicationContext context;
    private File pdConfFile;

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        MutablePropertySources sources = event.getEnvironment().getPropertySources();
        String pdAddress = event.getEnvironment().getProperty("pdserver.address");
        this.pdConfFile = new File(this.configFilePath);
        KvClient client = new KvClient(PDConfig.of((String)pdAddress));
        try {
            ScanPrefixResponse response = client.scanPrefix(CONFIG_PREFIX);
            Map kvsMap = response.getKvsMap();
            String pdConfig = (String)kvsMap.get(CONFIG_FIX_PREFIX);
            if (!StringUtils.isEmpty((String)pdConfig)) {
                this.updatePdConfig(sources, client, pdConfig);
            } else if (this.pdConfFile.exists()) {
                String commons = FileUtils.readFileToString((File)this.pdConfFile, (Charset)Charsets.UTF_8);
                log.info("send local application-pd.yml to pd....{}", (Object)commons);
                client.put(CONFIG_FIX_PREFIX, commons);
            }
            log.info("Start listening for keys :S:Timestamp");
            client.listen(TIMESTAMP_KEY, o -> {
                log.info("receive message to restart :" + String.valueOf(o));
                try {
                    ScanPrefixResponse responseNew = client.scanPrefix(CONFIG_PREFIX);
                    Map kvsMapNew = responseNew.getKvsMap();
                    String config = (String)kvsMapNew.get(CONFIG_FIX_PREFIX);
                    this.updatePdConfig(sources, client, config);
                    this.restart();
                }
                catch (Exception e) {
                    log.error("start listener with error:", (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            log.error("start listener with error:", (Throwable)e);
        }
    }

    private void updatePdConfig(MutablePropertySources sources, KvClient client, String pdConfig) throws PDException, IOException {
        Properties configs = this.getYmlConfig(pdConfig);
        String property = client.get(TIMESTAMP_KEY).getValue();
        long pdLastModified = 0L;
        if (!StringUtils.isEmpty((String)property)) {
            pdLastModified = Long.parseLong(property);
        }
        if (!this.pdConfFile.exists() || this.pdConfFile.lastModified() <= pdLastModified) {
            log.info("update local application-pd.yml from pd....{}", (Object)pdConfig);
            this.writeYml(pdConfig);
            PropertiesPropertySource source = new PropertiesPropertySource("pd-config", configs);
            sources.addFirst((PropertySource)source);
        }
    }

    private Properties getYmlConfig(String yml) {
        Yaml yaml = new Yaml();
        Iterable load = yaml.loadAll(yml);
        Iterator iterator = load.iterator();
        Properties properties = new Properties();
        while (iterator.hasNext()) {
            Map next = (Map)iterator.next();
            this.map2Properties(next, "", properties);
        }
        return properties;
    }

    private void map2Properties(Map<String, Object> map, String prefix, Properties properties) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            String newPrefix = StringUtils.isEmpty((String)prefix) ? key : prefix + "." + key;
            Object value = entry.getValue();
            if (!(value instanceof Map)) {
                properties.put(newPrefix, value);
                continue;
            }
            this.map2Properties((Map)value, newPrefix, properties);
        }
    }

    public ConfigurableApplicationContext getContext() {
        return this.context;
    }

    public void setContext(ConfigurableApplicationContext context) {
        this.context = context;
    }

    private void restart() throws InterruptedException, IOException {
        ProcessBuilder builder;
        String os = System.getProperty("os.name");
        if (os.toLowerCase(Locale.getDefault()).contains("win")) {
            builder = new ProcessBuilder("cmd", "/c", this.restartShellPath).inheritIO();
        } else {
            log.info("run shell {}", (Object)this.restartShellPath);
            builder = new ProcessBuilder("sh", "-c", this.restartShellPath).inheritIO();
        }
        SecureRandom random = new SecureRandom();
        int sleepTime = random.nextInt(60);
        log.info("app will restart in {} seconds:", (Object)sleepTime);
        Thread.sleep(sleepTime * 1000);
        Process process = builder.start();
        log.info("waiting restart.... {}", (Object)this.restartShellPath);
        process.waitFor();
    }

    private void writeYml(String yml) throws IOException {
        FileUtils.writeStringToFile((File)this.pdConfFile, (String)yml, (Charset)Charset.defaultCharset(), (boolean)false);
    }
}

