/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.listener;

import java.io.File;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hugegraph.store.node.AppConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;

public class PlaceHolderListener
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(PlaceHolderListener.class);

    public void onApplicationEvent(ApplicationReadyEvent event) {
        try {
            AppConfig config = (AppConfig)event.getApplicationContext().getBean(AppConfig.class);
            String dataPath = config.getDataPath();
            String[] paths = dataPath.split(",");
            Integer size = config.getPlaceholderSize();
            ((Stream)Arrays.stream(paths).parallel()).forEach(path -> {
                File ph;
                if (!StringUtils.isEmpty((String)path) && !(ph = new File(path + "/placeholder")).exists() && size > 0) {
                    try {
                        FileUtils.touch((File)ph);
                        byte[] tmp = new byte[0x40000000];
                        for (int j = 0; j < size; ++j) {
                            FileUtils.writeByteArrayToFile((File)ph, (byte[])tmp, (boolean)true);
                        }
                        RandomAccessFile raf = new RandomAccessFile(ph, "rw");
                        raf.setLength((long)size.intValue() * 0x40000000L);
                    }
                    catch (Exception e) {
                        log.info("creating placeholder file got exception:", (Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("create placeholder file with error:", (Throwable)e);
        }
    }
}

