/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.task;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.protobuf.ByteString;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.hugegraph.pd.client.KvClient;
import org.apache.hugegraph.pd.client.PDConfig;
import org.apache.hugegraph.pd.grpc.kv.KResponse;
import org.apache.hugegraph.rocksdb.access.RocksDBSession;
import org.apache.hugegraph.rocksdb.access.ScanIterator;
import org.apache.hugegraph.rocksdb.access.SessionOperator;
import org.apache.hugegraph.serializer.DirectBinarySerializer;
import org.apache.hugegraph.store.HgStoreEngine;
import org.apache.hugegraph.store.business.BusinessHandler;
import org.apache.hugegraph.store.business.BusinessHandlerImpl;
import org.apache.hugegraph.store.business.InnerKeyCreator;
import org.apache.hugegraph.store.business.InnerKeyFilter;
import org.apache.hugegraph.store.node.AppConfig;
import org.apache.hugegraph.store.node.grpc.HgStoreNodeService;
import org.apache.hugegraph.store.node.task.ttl.DefaulTaskSubmitter;
import org.apache.hugegraph.store.node.task.ttl.RaftTaskSubmitter;
import org.apache.hugegraph.store.node.task.ttl.TaskInfo;
import org.apache.hugegraph.store.node.task.ttl.TaskSubmitter;
import org.apache.hugegraph.store.pd.DefaultPdProvider;
import org.apache.hugegraph.store.pd.PdProvider;
import org.apache.hugegraph.store.util.DefaultThreadFactory;
import org.apache.hugegraph.store.util.ExecutorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TTLCleaner
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(TTLCleaner.class);
    private static final String[] tables = new String[]{"g+v", "g+ie", "g+oe", "g+index"};
    private final ScheduledExecutorService scheduler;
    private final HgStoreEngine storeEngine;
    private PdProvider pd;
    private KvClient client;
    private ThreadPoolExecutor executor;
    private final Set<Integer> failedPartitions = Sets.newConcurrentHashSet();
    private final ScheduledFuture<?> future;
    private final String key = "HUGEGRAPH/hg/EXPIRED";
    private final DirectBinarySerializer serializer = new DirectBinarySerializer();
    @Autowired
    private HgStoreNodeService service;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final AppConfig appConfig;
    private final AppConfig.JobConfig jobConfig;

    public TTLCleaner(@Autowired AppConfig config) {
        LocalDateTime next;
        Duration between;
        long delay;
        this.appConfig = config;
        this.jobConfig = config.getJobConfig();
        LocalDateTime now = LocalDateTime.now();
        int startTime = this.jobConfig.getStartTime();
        if (startTime < 0 || startTime > 23) {
            startTime = 19;
        }
        if ((delay = (between = Duration.between(now, next = now.withHour(startTime).withMinute(0).withSecond(0).withNano(0))).getSeconds()) < 0L) {
            delay += 86400L;
        }
        log.info("clean task will begin in {} seconds", (Object)delay);
        DefaultThreadFactory factory = new DefaultThreadFactory("ttl-cleaner");
        this.scheduler = new ScheduledThreadPoolExecutor(1, (ThreadFactory)factory);
        this.future = this.scheduler.scheduleAtFixedRate((Runnable)this, delay, 86400L, TimeUnit.SECONDS);
        this.storeEngine = HgStoreEngine.getInstance();
    }

    public void submit() {
        this.scheduler.submit((Runnable)this);
    }

    public BiFunction<byte[], byte[], Boolean> getJudge(String table) {
        try {
            switch (table) {
                case "g+v": {
                    return (key, value) -> {
                        DirectBinarySerializer.DirectHugeElement el = this.serializer.parseVertex(key, value);
                        return this.predicate(el);
                    };
                }
                case "g+oe": 
                case "g+ie": {
                    return (key, value) -> {
                        DirectBinarySerializer.DirectHugeElement el = this.serializer.parseEdge(key, value);
                        return this.predicate(el);
                    };
                }
                case "g+index": {
                    return (key, value) -> {
                        DirectBinarySerializer.DirectHugeElement el = this.serializer.parseIndex(key, value);
                        return this.predicate(el);
                    };
                }
            }
            throw new UnsupportedOperationException("unsupported table");
        }
        catch (Exception e) {
            log.error("failed to parse entry: ", (Throwable)e);
            throw e;
        }
    }

    private Boolean predicate(DirectBinarySerializer.DirectHugeElement el) {
        long expiredTime = el.expiredTime();
        if (this.expired(expiredTime)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private boolean expired(long expiredTime) {
        return expiredTime != 0L && expiredTime < System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.running.compareAndSet(false, true)) {
            return;
        }
        try {
            this.running.set(true);
            if (this.client == null) {
                PDConfig config = PDConfig.of((String)this.appConfig.getPdServerAddress());
                config.setAuthority(DefaultPdProvider.name, DefaultPdProvider.authority);
                this.client = new KvClient(config);
            }
            KResponse k = this.client.get("HUGEGRAPH/hg/EXPIRED");
            String g = k.getValue();
            log.info("cleaner config:{}", (Object)this.jobConfig);
            if (this.executor == null) {
                this.executor = ExecutorUtil.createExecutor((String)"hg-i-job", (int)this.jobConfig.getCore(), (int)this.jobConfig.getMax(), (int)this.jobConfig.getQueueSize());
            }
            BusinessHandlerImpl handler = (BusinessHandlerImpl)this.storeEngine.getBusinessHandler();
            if (!StringUtils.isEmpty((CharSequence)g)) {
                Object[] graphs = StringUtils.split((String)g, (String)",");
                log.info("clean task got graphs:{}", (Object)Arrays.toString(graphs));
                if (ArrayUtils.isEmpty((Object[])graphs)) {
                    return;
                }
                this.runAll((String[])graphs, handler);
            } else {
                log.info("there is no specific graph to clean up and will do compact directly");
                Set leaderPartitions = handler.getLeaderPartitionIdSet();
                leaderPartitions.forEach(p -> new RaftTaskSubmitter(this.service, (BusinessHandler)handler).submitCompaction(p));
            }
        }
        catch (Exception e) {
            log.error("clean ttl with error.", (Throwable)e);
        }
        finally {
            this.running.set(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void runAll(String[] graphs, BusinessHandlerImpl handler) throws InterruptedException {
        void var10_11;
        long start = System.currentTimeMillis();
        ConcurrentHashMap<String, TaskInfo> tasks = new ConcurrentHashMap<String, TaskInfo>(graphs.length);
        LinkedList<ImmutableTriple> elements = new LinkedList<ImmutableTriple>();
        ConcurrentHashMap<Integer, AtomicLong> pc = new ConcurrentHashMap<Integer, AtomicLong>();
        String[] stringArray = graphs;
        int n = stringArray.length;
        boolean bl = false;
        while (var10_11 < n) {
            String graph = stringArray[var10_11];
            if (!StringUtils.isEmpty((CharSequence)graph)) {
                String[] fields = graph.split(":");
                long startTime = 0L;
                boolean isRaft = false;
                if (fields.length > 0) {
                    String graphName = fields[0];
                    if (fields.length > 1) {
                        String time = StringUtils.isEmpty((CharSequence)fields[1]) ? "0" : fields[1];
                        startTime = Long.parseLong(time);
                    }
                    if (fields.length > 2) {
                        String raft;
                        String string = raft = StringUtils.isEmpty((CharSequence)fields[2]) ? "0" : fields[2];
                        if ("1".equals(raft)) {
                            isRaft = true;
                        }
                    }
                    TaskInfo taskInfo = new TaskInfo(handler, graphName, isRaft, startTime, tables, this.service);
                    tasks.put(graphName, taskInfo);
                    List ids = taskInfo.getPartitionIds();
                    for (Integer pId : ids) {
                        for (String table : tables) {
                            ImmutableTriple triple = new ImmutableTriple((Object)pId, (Object)graphName, (Object)table);
                            elements.add(triple);
                        }
                        pc.putIfAbsent(pId, new AtomicLong(0L));
                    }
                }
            }
            ++var10_11;
        }
        CountDownLatch latch = new CountDownLatch(elements.size());
        for (Triple triple : elements) {
            Runnable r = this.getTask(handler, latch, triple, tasks, pc);
            this.executor.execute(r);
        }
        latch.await();
        for (Map.Entry entry : pc.entrySet()) {
            AtomicLong count = (AtomicLong)entry.getValue();
            if (count.get() <= 0L) continue;
            Integer id = (Integer)entry.getKey();
            new DefaulTaskSubmitter(this.service, (BusinessHandler)handler).submitCompaction(id);
        }
        Gson gson = new Gson();
        String string = gson.toJson(tasks);
        long end = System.currentTimeMillis();
        log.info("clean data cost:{}, size :{}", (Object)(end - start), (Object)string);
    }

    private Runnable getTask(BusinessHandlerImpl handler, CountDownLatch latch, Triple<Integer, String, String> t, Map<String, TaskInfo> counter, Map<Integer, AtomicLong> pc) {
        int batchSize = this.appConfig.getJobConfig().getBatchSize();
        return () -> {
            Integer id = (Integer)t.getLeft();
            String graph = (String)t.getMiddle();
            String table = (String)t.getRight();
            TaskInfo taskInfo = (TaskInfo)counter.get(graph);
            ScanIterator scan = null;
            try {
                ConcurrentHashMap graphCounter = taskInfo.getTableCounter();
                TaskSubmitter submitter = taskInfo.getTaskSubmitter();
                AtomicLong tableCounter = (AtomicLong)graphCounter.get(table);
                RocksDBSession session = handler.getSession(id.intValue());
                InnerKeyCreator keyCreator = handler.getKeyCreator();
                SessionOperator op = session.sessionOp();
                BiFunction judge = this.getJudge(table);
                scan = op.scan(table, keyCreator.getStartKey(id, graph), keyCreator.getEndKey(id, graph), 16);
                InnerKeyFilter filter = new InnerKeyFilter(scan, true);
                LinkedList<ByteString> all = new LinkedList<ByteString>();
                AtomicBoolean state = new AtomicBoolean(true);
                AtomicLong partitionCounter = (AtomicLong)pc.get(id);
                while (filter.hasNext() && state.get()) {
                    RocksDBSession.BackendColumn current = filter.next();
                    byte[] realKey = Arrays.copyOfRange(current.name, 0, current.name.length - 2);
                    if (((Boolean)judge.apply(realKey, current.value)).booleanValue()) {
                        ByteString e = ByteString.copyFrom((byte[])current.name);
                        all.add(e);
                    }
                    if (all.size() < batchSize) continue;
                    submitter.submitClean(id, graph, table, all, state, tableCounter, partitionCounter);
                    all = new LinkedList();
                }
                if (all.size() > 0 && state.get()) {
                    submitter.submitClean(id, graph, table, all, state, tableCounter, partitionCounter);
                }
                log.info("id:{}, graph:{}, table:{}, count:{} clean ttl data done and will do compact", new Object[]{id, graph, table, tableCounter.get()});
            }
            catch (Exception e) {
                String s = "clean ttl with error by: partition-%s,graph-%s,table-%s:";
                String msg = String.format(s, id, graph, table);
                log.error(msg, (Throwable)e);
            }
            finally {
                latch.countDown();
                if (scan != null) {
                    scan.close();
                }
            }
        };
    }

    public ScheduledFuture<?> getFuture() {
        return this.future;
    }

    public ThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }
}

