/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.task.ttl;

import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.error.RaftError;
import com.google.protobuf.ByteString;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hugegraph.store.business.BusinessHandler;
import org.apache.hugegraph.store.node.grpc.HgStoreNodeService;
import org.apache.hugegraph.store.node.task.ttl.TaskSubmitter;

public class DefaulTaskSubmitter
extends TaskSubmitter {
    public DefaulTaskSubmitter(HgStoreNodeService service, BusinessHandler handler) {
        super(service, handler);
    }

    public Status submitClean(Integer id, String graph, String table, LinkedList<ByteString> all, AtomicBoolean state, AtomicLong tableCounter, AtomicLong partitionCounter) {
        try {
            this.handler.cleanTtl(graph, id.intValue(), table, all);
            tableCounter.getAndAdd(all.size());
            partitionCounter.getAndAdd(all.size());
            return Status.OK();
        }
        catch (Exception e) {
            return new Status(RaftError.UNKNOWN, e.getMessage(), new Object[0]);
        }
    }

    public Status submitCompaction(Integer id) {
        this.handler.dbCompaction("", id.intValue());
        return Status.OK();
    }
}

