/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.matchers;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.parboiled.Action;
import org.parboiled.Context;
import org.parboiled.ContextAware;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.SkippableAction;
import org.parboiled.common.Preconditions;
import org.parboiled.errors.ActionError;
import org.parboiled.errors.ActionException;
import org.parboiled.matchers.AbstractMatcher;
import org.parboiled.matchervisitors.MatcherVisitor;

public class ActionMatcher
extends AbstractMatcher {
    public final Action action;
    public final List<ContextAware> contextAwares = new ArrayList<ContextAware>();
    public final boolean skipInPredicates;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionMatcher(Action action) {
        super(Preconditions.checkArgNotNull(action, "action").toString());
        this.action = action;
        boolean bl = this.skipInPredicates = action instanceof SkippableAction && ((SkippableAction)action).skipInPredicates();
        if (action.getClass().isSynthetic()) {
            return;
        }
        if (action instanceof ContextAware) {
            this.contextAwares.add((ContextAware)((Object)action));
        }
        for (Field field : action.getClass().getDeclaredFields()) {
            if (!field.isSynthetic() || !ContextAware.class.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            try {
                ContextAware contextAware = (ContextAware)field.get(action);
                if (contextAware == null) continue;
                this.contextAwares.add(contextAware);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            finally {
                field.setAccessible(false);
            }
        }
    }

    @Override
    public MatcherContext getSubContext(MatcherContext matcherContext) {
        MatcherContext matcherContext2 = matcherContext.getBasicSubContext();
        matcherContext2.setMatcher(this);
        if (matcherContext.getCurrentIndex() > matcherContext.getStartIndex()) {
            return matcherContext2;
        }
        return matcherContext.getSubContext(this);
    }

    @Override
    public <V> boolean match(MatcherContext<V> matcherContext) {
        if (this.skipInPredicates && matcherContext.inPredicate()) {
            return true;
        }
        Context context = matcherContext.getParent();
        if (!this.contextAwares.isEmpty()) {
            for (ContextAware contextAware : this.contextAwares) {
                contextAware.setContext(context);
            }
        }
        try {
            Object object = matcherContext.getValueStack().takeSnapshot();
            if (!this.action.run(context)) {
                matcherContext.getValueStack().restoreSnapshot(object);
                return false;
            }
            matcherContext.setCurrentIndex(((MatcherContext)context).getCurrentIndex());
            return true;
        }
        catch (ActionException actionException) {
            matcherContext.getParseErrors().add(new ActionError(matcherContext.getInputBuffer(), matcherContext.getCurrentIndex(), actionException.getMessage(), matcherContext.getPath(), actionException));
            return false;
        }
    }

    @Override
    public Rule suppressNode() {
        return this;
    }

    @Override
    public <R> R accept(MatcherVisitor<R> matcherVisitor) {
        Preconditions.checkArgNotNull(matcherVisitor, "visitor");
        return matcherVisitor.visit(this);
    }
}

