/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.MapConfiguration;
import org.apache.hugegraph.HugeGraphSupplier;
import org.apache.hugegraph.SchemaDriver;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.id.Id;
import org.apache.hugegraph.pd.client.PDConfig;
import org.apache.hugegraph.struct.schema.EdgeLabel;
import org.apache.hugegraph.struct.schema.IndexLabel;
import org.apache.hugegraph.struct.schema.PropertyKey;
import org.apache.hugegraph.struct.schema.SchemaElement;
import org.apache.hugegraph.struct.schema.VertexLabel;
import org.apache.hugegraph.util.E;

public class SchemaGraph
implements HugeGraphSupplier {
    private final String graphSpace;
    private final String graph;
    private final PDConfig pdConfig;
    private final HugeConfig config;
    private final SchemaDriver schemaDriver;

    public SchemaGraph(String graphSpace, String graph, PDConfig pdConfig) {
        this.graphSpace = graphSpace;
        this.graph = graph;
        this.pdConfig = pdConfig;
        this.schemaDriver = this.schemaDriverInit();
        this.config = this.loadConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SchemaDriver schemaDriverInit() {
        if (SchemaDriver.getInstance() != null) return SchemaDriver.getInstance();
        Class<SchemaDriver> clazz = SchemaDriver.class;
        synchronized (SchemaDriver.class) {
            if (SchemaDriver.getInstance() != null) return SchemaDriver.getInstance();
            SchemaDriver.init(this.pdConfig);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return SchemaDriver.getInstance();
        }
    }

    private HugeConfig loadConfig() {
        Map<String, Object> configs = this.schemaDriver.graphConfig(this.graphSpace, this.graph);
        MapConfiguration propConfig = new MapConfiguration(configs);
        return new HugeConfig((Configuration)propConfig);
    }

    @Override
    public List<String> mapPkId2Name(Collection<Id> ids) {
        ArrayList<String> names = new ArrayList<String>(ids.size());
        for (Id id : ids) {
            PropertyKey schema = this.propertyKey(id);
            names.add(schema.name());
        }
        return names;
    }

    @Override
    public List<String> mapIlId2Name(Collection<Id> ids) {
        ArrayList<String> names = new ArrayList<String>(ids.size());
        for (Id id : ids) {
            IndexLabel schema = this.indexLabel(id);
            names.add(schema.name());
        }
        return names;
    }

    @Override
    public HugeConfig configuration() {
        return this.config;
    }

    @Override
    public PropertyKey propertyKey(Id id) {
        return this.schemaDriver.propertyKey(this.graphSpace, this.graph, id, (HugeGraphSupplier)this);
    }

    public PropertyKey propertyKey(String name) {
        return this.schemaDriver.propertyKey(this.graphSpace, this.graph, name, (HugeGraphSupplier)this);
    }

    @Override
    public Collection<PropertyKey> propertyKeys() {
        return null;
    }

    @Override
    public VertexLabel vertexLabelOrNone(Id id) {
        VertexLabel vl = this.vertexLabel(id);
        if (vl == null) {
            vl = VertexLabel.undefined(null, id);
        }
        return vl;
    }

    @Override
    public boolean existsLinkLabel(Id vertexLabel) {
        List<EdgeLabel> edgeLabels = this.schemaDriver.edgeLabels(this.graphSpace, this.graph, this);
        for (EdgeLabel edgeLabel : edgeLabels) {
            if (!edgeLabel.linkWithLabel(vertexLabel)) continue;
            return true;
        }
        return false;
    }

    @Override
    public VertexLabel vertexLabel(Id id) {
        E.checkArgumentNotNull((Object)id, (String)"Vertex label id can't be null", (Object[])new Object[0]);
        if (SchemaElement.OLAP_ID.equals(id)) {
            return VertexLabel.OLAP_VL;
        }
        return this.schemaDriver.vertexLabel(this.graphSpace, this.graph, id, (HugeGraphSupplier)this);
    }

    @Override
    public VertexLabel vertexLabel(String name) {
        E.checkArgumentNotNull((Object)name, (String)"Vertex label name can't be null", (Object[])new Object[0]);
        E.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (String)"Vertex label name can't be empty", (Object[])new Object[0]);
        if ("~olap".equals(name)) {
            return VertexLabel.OLAP_VL;
        }
        return this.schemaDriver.vertexLabel(this.graphSpace, this.graph, name, (HugeGraphSupplier)this);
    }

    @Override
    public EdgeLabel edgeLabel(Id id) {
        return this.schemaDriver.edgeLabel(this.graphSpace, this.graph, id, (HugeGraphSupplier)this);
    }

    @Override
    public EdgeLabel edgeLabel(String name) {
        return this.schemaDriver.edgeLabel(this.graphSpace, this.graph, name, (HugeGraphSupplier)this);
    }

    @Override
    public IndexLabel indexLabel(Id id) {
        return this.schemaDriver.indexLabel(this.graphSpace, this.graph, id, (HugeGraphSupplier)this);
    }

    @Override
    public Collection<IndexLabel> indexLabels() {
        return this.schemaDriver.indexLabels(this.graphSpace, this.graph, this);
    }

    public IndexLabel indexLabel(String name) {
        return this.schemaDriver.indexLabel(this.graphSpace, this.graph, name, (HugeGraphSupplier)this);
    }

    @Override
    public String name() {
        return String.join((CharSequence)"-", this.graphSpace, this.graph);
    }
}

