/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.query;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hugegraph.struct.schema.IndexLabel;
import org.apache.hugegraph.struct.schema.SchemaLabel;

public class MatchedIndex {
    private final SchemaLabel schemaLabel;
    private final Set<IndexLabel> indexLabels;

    public MatchedIndex(SchemaLabel schemaLabel, Set<IndexLabel> indexLabels) {
        this.schemaLabel = schemaLabel;
        this.indexLabels = indexLabels;
    }

    public SchemaLabel schemaLabel() {
        return this.schemaLabel;
    }

    public Set<IndexLabel> indexLabels() {
        return Collections.unmodifiableSet(this.indexLabels);
    }

    public boolean containsSearchIndex() {
        for (IndexLabel il : this.indexLabels) {
            if (!il.indexType().isSearch()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.indexLabels.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof MatchedIndex)) {
            return false;
        }
        Set<IndexLabel> indexLabels = ((MatchedIndex)other).indexLabels;
        return Objects.equals(this.indexLabels, indexLabels);
    }

    public String toString() {
        String strIndexLabels = this.indexLabels.stream().map(i -> i.name()).collect(Collectors.joining(","));
        return "MatchedIndex{schemaLabel=" + this.schemaLabel.name() + ", indexLabels=" + strIndexLabels + "}";
    }
}

