/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.structure;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.hugegraph.HugeGraphSupplier;
import org.apache.hugegraph.exception.HugeException;
import org.apache.hugegraph.id.Id;
import org.apache.hugegraph.id.IdGenerator;
import org.apache.hugegraph.id.SplicingIdGenerator;
import org.apache.hugegraph.serializer.BytesBuffer;
import org.apache.hugegraph.struct.schema.IndexLabel;
import org.apache.hugegraph.struct.schema.SchemaElement;
import org.apache.hugegraph.type.GraphType;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.DataType;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.InsertionOrderUtil;
import org.apache.hugegraph.util.NumericUtil;

public class Index
implements GraphType,
Cloneable {
    private final HugeGraphSupplier graph;
    private Object fieldValues;
    private final IndexLabel indexLabel;
    private Set<IdWithExpiredTime> elementIds;
    private IdWithExpiredTime elementId;

    public Index(HugeGraphSupplier graph, IndexLabel indexLabel) {
        E.checkNotNull((Object)graph, (String)"graph");
        E.checkNotNull((Object)indexLabel, (String)"label");
        E.checkNotNull((Object)indexLabel.id(), (String)"label id");
        this.graph = graph;
        this.indexLabel = indexLabel;
        this.elementIds = new LinkedHashSet<IdWithExpiredTime>();
        this.fieldValues = null;
    }

    public Index(HugeGraphSupplier graph, IndexLabel indexLabel, boolean write) {
        E.checkNotNull((Object)graph, (String)"graph");
        E.checkNotNull((Object)indexLabel, (String)"label");
        E.checkNotNull((Object)indexLabel.id(), (String)"label id");
        this.graph = graph;
        this.indexLabel = indexLabel;
        if (!write) {
            this.elementIds = new LinkedHashSet<IdWithExpiredTime>();
        }
        this.elementId = null;
        this.fieldValues = null;
    }

    @Override
    public String name() {
        return this.indexLabel.name();
    }

    @Override
    public HugeType type() {
        if (this.indexLabel == IndexLabel.label(HugeType.VERTEX)) {
            return HugeType.VERTEX_LABEL_INDEX;
        }
        if (this.indexLabel == IndexLabel.label(HugeType.EDGE)) {
            return HugeType.EDGE_LABEL_INDEX;
        }
        return this.indexLabel.indexType().type();
    }

    public HugeGraphSupplier graph() {
        return this.graph;
    }

    public Id id() {
        return Index.formatIndexId(this.type(), this.indexLabelId(), this.fieldValues());
    }

    public Object fieldValues() {
        return this.fieldValues;
    }

    public void fieldValues(Object fieldValues) {
        this.fieldValues = fieldValues;
    }

    public Id indexLabelId() {
        return this.indexLabel.id();
    }

    public IndexLabel indexLabel() {
        return this.indexLabel;
    }

    public IdWithExpiredTime elementIdWithExpiredTime() {
        if (this.elementIds == null) {
            return this.elementId;
        }
        E.checkState((this.elementIds.size() == 1 ? 1 : 0) != 0, (String)"Expect one element id, actual %s", (Object[])new Object[]{this.elementIds.size()});
        return this.elementIds.iterator().next();
    }

    public Id elementId() {
        return this.elementIdWithExpiredTime().id();
    }

    public Set<Id> elementIds() {
        if (this.elementIds == null) {
            return ImmutableSet.of();
        }
        Set ids = InsertionOrderUtil.newSet((int)this.elementIds.size());
        for (IdWithExpiredTime idWithExpiredTime : this.elementIds) {
            ids.add(idWithExpiredTime.id());
        }
        return Collections.unmodifiableSet(ids);
    }

    public Set<IdWithExpiredTime> expiredElementIds() {
        long now = this.graph.now();
        Set expired = InsertionOrderUtil.newSet();
        for (IdWithExpiredTime id : this.elementIds) {
            if (0L >= id.expiredTime || id.expiredTime >= now) continue;
            expired.add(id);
        }
        this.elementIds.removeAll(expired);
        return expired;
    }

    public void elementIds(Id elementId) {
        this.elementIds(elementId, 0L);
    }

    public void elementIds(Id elementId, long expiredTime) {
        if (this.elementIds == null) {
            this.elementId = new IdWithExpiredTime(elementId, expiredTime);
        } else {
            this.elementIds.add(new IdWithExpiredTime(elementId, expiredTime));
        }
    }

    public void resetElementIds() {
        this.elementIds = null;
    }

    public long expiredTime() {
        return this.elementIdWithExpiredTime().expiredTime();
    }

    public boolean hasTtl() {
        if ((this.indexLabel() == IndexLabel.label(HugeType.VERTEX) || this.indexLabel() == IndexLabel.label(HugeType.EDGE)) && this.expiredTime() > 0L) {
            return true;
        }
        if (this.indexLabel.system()) {
            return false;
        }
        return this.indexLabel.baseElement().ttl() > 0L;
    }

    public long ttl() {
        return this.expiredTime() - this.graph.now();
    }

    public Index clone() {
        try {
            return (Index)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new HugeException("Failed to clone Index", e);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Index)) {
            return false;
        }
        Index other = (Index)obj;
        return this.id().equals(other.id());
    }

    public int hashCode() {
        return this.id().hashCode();
    }

    public String toString() {
        return String.format("{label=%s<%s>, fieldValues=%s, elementIds=%s}", this.indexLabel.name(), this.indexLabel.indexType().string(), this.fieldValues, this.elementIds);
    }

    public static Id formatIndexId(HugeType type, Id indexLabelId, Object fieldValues) {
        if (type.isStringIndex()) {
            String value = "";
            if (fieldValues instanceof Id) {
                value = IdGenerator.asStoredString((Id)fieldValues);
            } else if (fieldValues != null) {
                value = fieldValues.toString();
            }
            String strIndexLabelId = IdGenerator.asStoredString(indexLabelId);
            return SplicingIdGenerator.splicing(type.string(), strIndexLabelId, value);
        }
        assert (type.isRangeIndex());
        int length = type.isRange4Index() ? 4 : 8;
        BytesBuffer buffer = BytesBuffer.allocate(5 + length);
        buffer.write(type.code());
        buffer.writeInt(SchemaElement.schemaId(indexLabelId));
        if (fieldValues != null) {
            E.checkState((boolean)(fieldValues instanceof Number), (String)"Field value of range index must be number: %s", (Object[])new Object[]{fieldValues.getClass().getSimpleName()});
            byte[] bytes = Index.number2bytes((Number)fieldValues);
            buffer.write(bytes);
        }
        return buffer.asId();
    }

    public static Index parseIndexId(HugeGraphSupplier graph, HugeType type, byte[] id) {
        Object values;
        IndexLabel indexLabel;
        if (type.isStringIndex()) {
            Id idObject = IdGenerator.of(id, Id.IdType.STRING);
            String[] parts = SplicingIdGenerator.parse(idObject);
            E.checkState((parts.length == 3 ? 1 : 0) != 0, (String)"Invalid secondary index id", (Object[])new Object[0]);
            Id label = IdGenerator.ofStoredString(parts[1], Id.IdType.LONG);
            indexLabel = IndexLabel.label(graph, label);
            values = parts[2];
        } else {
            assert (type.isRange4Index() || type.isRange8Index());
            int labelLength = 4;
            E.checkState((id.length > 4 ? 1 : 0) != 0, (String)"Invalid range index id", (Object[])new Object[0]);
            BytesBuffer buffer = BytesBuffer.wrap(id);
            boolean hugeTypeCodeLength = true;
            byte[] read = buffer.read(1);
            Id label = IdGenerator.of(buffer.readInt());
            indexLabel = IndexLabel.label(graph, label);
            List<Id> fields = indexLabel.indexFields();
            E.checkState((fields.size() == 1 ? 1 : 0) != 0, (String)"Invalid range index fields", (Object[])new Object[0]);
            DataType dataType = graph.propertyKey(fields.get(0)).dataType();
            E.checkState((dataType.isNumber() || dataType.isDate() ? 1 : 0) != 0, (String)"Invalid range index field type", (Object[])new Object[0]);
            Class<?> clazz = dataType.isNumber() ? dataType.clazz() : DataType.LONG.clazz();
            values = Index.bytes2number(buffer.read(id.length - 4 - 1), clazz);
        }
        Index index = new Index(graph, indexLabel);
        index.fieldValues(values);
        return index;
    }

    public static byte[] number2bytes(Number number) {
        if (number instanceof Byte) {
            number = number.intValue();
        }
        return NumericUtil.numberToSortableBytes((Number)number);
    }

    public static Number bytes2number(byte[] bytes, Class<?> clazz) {
        return NumericUtil.sortableBytesToNumber((byte[])bytes, clazz);
    }

    public static class IdWithExpiredTime {
        private final Id id;
        private final long expiredTime;

        public IdWithExpiredTime(Id id, long expiredTime) {
            this.id = id;
            this.expiredTime = expiredTime;
        }

        public Id id() {
            return this.id;
        }

        public long expiredTime() {
            return this.expiredTime;
        }

        public String toString() {
            return String.format("%s(%s)", this.id, this.expiredTime);
        }
    }
}

