/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.structure.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.HugeGraphSupplier;
import org.apache.hugegraph.analyzer.Analyzer;
import org.apache.hugegraph.analyzer.AnalyzerFactory;
import org.apache.hugegraph.id.Id;
import org.apache.hugegraph.query.ConditionQuery;
import org.apache.hugegraph.struct.schema.EdgeLabel;
import org.apache.hugegraph.struct.schema.IndexLabel;
import org.apache.hugegraph.struct.schema.SchemaLabel;
import org.apache.hugegraph.struct.schema.VertexLabel;
import org.apache.hugegraph.structure.BaseEdge;
import org.apache.hugegraph.structure.BaseElement;
import org.apache.hugegraph.structure.BaseProperty;
import org.apache.hugegraph.structure.BaseVertex;
import org.apache.hugegraph.structure.Index;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.hugegraph.util.NumericUtil;
import org.slf4j.Logger;

public class IndexBuilder {
    private static final Logger LOG = Log.logger(IndexBuilder.class);
    private final HugeGraphSupplier graph;
    private final Analyzer textAnalyzer;
    public static final String INDEX_SYM_NULL = "\u0001";
    public static final String INDEX_SYM_EMPTY = "\u0002";
    public static final char INDEX_SYM_MAX = '\u0003';
    private static final String TEXT_ANALYZER = "search.text_analyzer";
    private static final String TEXT_ANALYZER_MODE = "search.text_analyzer_mode";
    private static final String DEFAULT_TEXT_ANALYZER = "ikanalyzer";
    private static final String DEFAULT_TEXT_ANALYZER_MODE = "smart";

    public IndexBuilder(HugeGraphSupplier graph) {
        this.graph = graph;
        String name = (String)graph.configuration().get(String.class, TEXT_ANALYZER);
        String mode = (String)graph.configuration().get(String.class, TEXT_ANALYZER_MODE);
        name = name == null ? DEFAULT_TEXT_ANALYZER : name;
        mode = mode == null ? DEFAULT_TEXT_ANALYZER_MODE : mode;
        LOG.debug("Loading text analyzer '{}' with mode '{}' for graph '{}'", new Object[]{name, mode, graph.name()});
        this.textAnalyzer = AnalyzerFactory.analyzer(name, mode);
    }

    public List<Index> buildLabelIndex(BaseElement element) {
        ArrayList<Index> indexList = new ArrayList<Index>();
        SchemaLabel label = element.schemaLabel();
        Index index = new Index(this.graph, IndexLabel.label(element.type()), true);
        index.fieldValues(element.schemaLabel().id());
        index.elementIds(element.id(), element.expiredTime());
        indexList.add(index);
        if (element instanceof BaseEdge && ((EdgeLabel)label).hasFather()) {
            Index fatherIndex = new Index(this.graph, IndexLabel.label(element.type()));
            fatherIndex.fieldValues(((EdgeLabel)label).fatherId());
            fatherIndex.elementIds(element.id(), element.expiredTime());
            indexList.add(fatherIndex);
        }
        return indexList;
    }

    public List<Index> buildVertexOlapIndex(BaseVertex vertex) {
        ArrayList<Index> indexs = new ArrayList<Index>();
        Id pkId = vertex.getProperties().keySet().iterator().next();
        Collection<IndexLabel> indexLabels = this.graph.indexLabels();
        for (IndexLabel il : indexLabels) {
            if (!il.indexFields().contains(pkId)) continue;
            indexs.addAll(this.buildIndex(vertex, il));
        }
        return indexs;
    }

    public List<Index> buildVertexIndex(BaseVertex vertex) {
        ArrayList<Index> indexs = new ArrayList<Index>();
        VertexLabel label = vertex.schemaLabel();
        if (label.enableLabelIndex()) {
            indexs.addAll(this.buildLabelIndex(vertex));
        }
        for (Id il : label.indexLabels()) {
            indexs.addAll(this.buildIndex(vertex, this.graph.indexLabel(il)));
        }
        return indexs;
    }

    public List<Index> buildEdgeIndex(BaseEdge edge) {
        ArrayList<Index> indexs = new ArrayList<Index>();
        EdgeLabel label = edge.schemaLabel();
        if (label.enableLabelIndex()) {
            indexs.addAll(this.buildLabelIndex(edge));
        }
        for (Id il : label.indexLabels()) {
            indexs.addAll(this.buildIndex(edge, this.graph.indexLabel(il)));
        }
        return indexs;
    }

    public List<Index> buildIndex(BaseElement element, IndexLabel indexLabel) {
        int fieldsNum;
        E.checkArgument((indexLabel != null ? 1 : 0) != 0, (String)"Not exist index label with id '%s'", (Object[])new Object[]{indexLabel.id()});
        ArrayList<Index> indexs = new ArrayList<Index>();
        ArrayList<Object> allPropValues = new ArrayList<Object>();
        int firstNullField = fieldsNum = indexLabel.indexFields().size();
        for (Id fieldId : indexLabel.indexFields()) {
            BaseProperty property = element.getProperty(fieldId);
            if (property == null) {
                E.checkState((boolean)IndexBuilder.hasNullableProp(element, fieldId), (String)"Non-null property '%s' is null for '%s'", (Object[])new Object[]{this.graph.propertyKey(fieldId), element});
                if (firstNullField == fieldsNum) {
                    firstNullField = allPropValues.size();
                }
                allPropValues.add(INDEX_SYM_NULL);
                continue;
            }
            E.checkArgument((!INDEX_SYM_NULL.equals(property.value()) ? 1 : 0) != 0, (String)"Illegal value of index property: '%s'", (Object[])new Object[]{INDEX_SYM_NULL});
            allPropValues.add(property.value());
        }
        if (firstNullField == 0 && !indexLabel.indexType().isUnique()) {
            return indexs;
        }
        List<Object> propValues = allPropValues.subList(0, firstNullField);
        long expiredTime = element.expiredTime();
        switch (indexLabel.indexType()) {
            case RANGE_INT: 
            case RANGE_FLOAT: 
            case RANGE_LONG: 
            case RANGE_DOUBLE: {
                E.checkState((propValues.size() == 1 ? 1 : 0) != 0, (String)"Expect only one property in range index", (Object[])new Object[0]);
                Number value = NumericUtil.convertToNumber((Object)propValues.get(0));
                indexs.add(this.buildIndex(indexLabel, value, element.id(), expiredTime));
                break;
            }
            case SEARCH: {
                E.checkState((propValues.size() == 1 ? 1 : 0) != 0, (String)"Expect only one property in search index", (Object[])new Object[0]);
                Object value = propValues.get(0);
                Set<String> words = this.segmentWords(IndexBuilder.propertyValueToString(value));
                for (String word : words) {
                    indexs.add(this.buildIndex(indexLabel, word, element.id(), expiredTime));
                }
                break;
            }
            case SECONDARY: {
                if (IndexBuilder.isCollectionIndex(propValues)) {
                    for (Object propValue : (Collection)propValues.get(0)) {
                        String value = ConditionQuery.concatValuesLimitLength(propValue);
                        value = IndexBuilder.escapeIndexValueIfNeeded(value);
                        indexs.add(this.buildIndex(indexLabel, value, element.id(), expiredTime));
                    }
                } else {
                    int n = propValues.size();
                    for (int i = 0; i < n; ++i) {
                        List<Object> prefixValues = propValues.subList(0, i + 1);
                        String value = ConditionQuery.concatValuesLimitLength(prefixValues);
                        value = IndexBuilder.escapeIndexValueIfNeeded(value);
                        indexs.add(this.buildIndex(indexLabel, value, element.id(), expiredTime));
                    }
                }
                break;
            }
            case SHARD: {
                String value = ConditionQuery.concatValuesLimitLength(propValues);
                value = IndexBuilder.escapeIndexValueIfNeeded(value);
                indexs.add(this.buildIndex(indexLabel, value, element.id(), expiredTime));
                break;
            }
            case UNIQUE: {
                String value = ConditionQuery.concatValuesLimitLength(allPropValues);
                assert (!"".equals(value));
                indexs.add(this.buildIndex(indexLabel, value, element.id(), expiredTime));
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unknown index type '%s'", indexLabel.indexType()));
            }
        }
        return indexs;
    }

    private Index buildIndex(IndexLabel indexLabel, Object propValue, Id elementId, long expiredTime) {
        Index index = new Index(this.graph, indexLabel, true);
        index.fieldValues(propValue);
        index.elementIds(elementId, expiredTime);
        return index;
    }

    private static String escapeIndexValueIfNeeded(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (ch > '\u0003') continue;
            E.checkArgument((boolean)false, (String)"Illegal char '\\u000%s' in index property: '%s'", (Object[])new Object[]{(int)ch, value});
        }
        if (value.isEmpty()) {
            value = INDEX_SYM_EMPTY;
        }
        return value;
    }

    private static boolean hasNullableProp(BaseElement element, Id key) {
        return element.schemaLabel().nullableKeys().contains(key);
    }

    private static boolean isCollectionIndex(List<Object> propValues) {
        return propValues.size() == 1 && propValues.get(0) instanceof Collection;
    }

    private Set<String> segmentWords(String text) {
        return this.textAnalyzer.segment(text);
    }

    private static String propertyValueToString(Object value) {
        return value instanceof Collection ? StringUtils.join((Object[])((Collection)value).toArray(), (String)" ") : value.toString();
    }
}

