/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.type.define;

import com.google.common.collect.ImmutableSet;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.hugegraph.exception.HugeException;
import org.apache.hugegraph.serializer.BytesBuffer;
import org.apache.hugegraph.type.define.SerialEnum;
import org.apache.hugegraph.util.Blob;
import org.apache.hugegraph.util.Bytes;
import org.apache.hugegraph.util.DateUtil;
import org.apache.hugegraph.util.StringEncoding;

public final class DataType
extends Enum<DataType>
implements SerialEnum {
    public static final /* enum */ DataType UNKNOWN = new DataType(0, "unknown", Object.class);
    public static final /* enum */ DataType OBJECT = new DataType(1, "object", Object.class);
    public static final /* enum */ DataType BOOLEAN = new DataType(2, "boolean", Boolean.class);
    public static final /* enum */ DataType BYTE = new DataType(3, "byte", Byte.class);
    public static final /* enum */ DataType INT = new DataType(4, "int", Integer.class);
    public static final /* enum */ DataType LONG = new DataType(5, "long", Long.class);
    public static final /* enum */ DataType FLOAT = new DataType(6, "float", Float.class);
    public static final /* enum */ DataType DOUBLE = new DataType(7, "double", Double.class);
    public static final /* enum */ DataType TEXT = new DataType(8, "text", String.class);
    public static final /* enum */ DataType BLOB = new DataType(9, "blob", Blob.class);
    public static final /* enum */ DataType DATE = new DataType(10, "date", Date.class);
    public static final /* enum */ DataType UUID = new DataType(11, "uuid", UUID.class);
    private final byte code;
    private final String name;
    private final Class<?> clazz;
    private static final ImmutableSet<String> SPECIAL_FLOATS;
    private static final /* synthetic */ DataType[] $VALUES;

    public static DataType[] values() {
        return (DataType[])$VALUES.clone();
    }

    public static DataType valueOf(String name) {
        return Enum.valueOf(DataType.class, name);
    }

    private DataType(int code, String name, Class<?> clazz) {
        assert (code < 256);
        this.code = (byte)code;
        this.name = name;
        this.clazz = clazz;
    }

    @Override
    public byte code() {
        return this.code;
    }

    public String string() {
        return this.name;
    }

    public Class<?> clazz() {
        return this.clazz;
    }

    public boolean isText() {
        return this == TEXT;
    }

    public boolean isNumber() {
        return this == BYTE || this == INT || this == LONG || this == FLOAT || this == DOUBLE;
    }

    public boolean isNumber4() {
        return this == BYTE || this == INT || this == FLOAT;
    }

    public boolean isNumber8() {
        return this == LONG || this == DOUBLE;
    }

    public boolean isBlob() {
        return this == BLOB;
    }

    public boolean isDate() {
        return this == DATE;
    }

    public boolean isUUID() {
        return this == UUID;
    }

    public <V> Number valueToNumber(V value) {
        Number number;
        if (!(this.isNumber() && value instanceof Number || value instanceof String && SPECIAL_FLOATS.contains(value))) {
            return null;
        }
        if (this.clazz.isInstance(value)) {
            return (Number)value;
        }
        try {
            switch (this) {
                case BYTE: {
                    number = Byte.valueOf(value.toString());
                    break;
                }
                case INT: {
                    number = Integer.valueOf(value.toString());
                    break;
                }
                case LONG: {
                    number = Long.valueOf(value.toString());
                    break;
                }
                case FLOAT: {
                    number = Float.valueOf(value.toString());
                    break;
                }
                case DOUBLE: {
                    number = Double.valueOf(value.toString());
                    break;
                }
                default: {
                    throw new AssertionError((Object)String.format("Number type only contains Byte, Integer, Long, Float, Double, but got %s", this.clazz()));
                }
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Can't read '%s' as %s: %s", value, this.name, e.getMessage()));
        }
        return number;
    }

    public <V> Date valueToDate(V value) {
        if (!this.isDate()) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Integer) {
            return new Date(((Number)value).intValue());
        }
        if (value instanceof Long) {
            return new Date(((Number)value).longValue());
        }
        if (value instanceof String) {
            return DateUtil.parse((String)((String)value));
        }
        return null;
    }

    public <V> UUID valueToUUID(V value) {
        if (!this.isUUID()) {
            return null;
        }
        if (value instanceof UUID) {
            return (UUID)value;
        }
        if (value instanceof String) {
            return StringEncoding.uuid((String)value);
        }
        return null;
    }

    public <V> Blob valueToBlob(V value) {
        if (!this.isBlob()) {
            return null;
        }
        if (value instanceof Blob) {
            return (Blob)value;
        }
        if (value instanceof byte[]) {
            return Blob.wrap((byte[])value);
        }
        if (value instanceof ByteBuffer) {
            return Blob.wrap(((ByteBuffer)value).array());
        }
        if (value instanceof BytesBuffer) {
            return Blob.wrap(((BytesBuffer)value).bytes());
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.startsWith("0x")) {
                return Blob.wrap(Bytes.fromHex((String)str.substring(2)));
            }
            return Blob.wrap(StringEncoding.decodeBase64(str));
        }
        if (value instanceof List) {
            List values = (List)value;
            byte[] bytes = new byte[values.size()];
            for (int i = 0; i < bytes.length; ++i) {
                Object v = values.get(i);
                if (!(v instanceof Byte) && !(v instanceof Integer)) {
                    throw new IllegalArgumentException(String.format("expect byte or int value, but got '%s'", v));
                }
                bytes[i] = ((Number)v).byteValue();
            }
            return Blob.wrap(bytes);
        }
        return null;
    }

    public static DataType fromClass(Class<?> clazz) {
        for (DataType type : DataType.values()) {
            if (type.clazz() != clazz) continue;
            return type;
        }
        throw new HugeException("Unknown clazz '%s' for DataType", clazz);
    }

    static {
        $VALUES = new DataType[]{UNKNOWN, OBJECT, BOOLEAN, BYTE, INT, LONG, FLOAT, DOUBLE, TEXT, BLOB, DATE, UUID};
        SPECIAL_FLOATS = ImmutableSet.of((Object)"-Infinity", (Object)"Infinity", (Object)"NaN");
        SerialEnum.register(DataType.class);
    }
}

