/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.type.define;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hugegraph.exception.HugeException;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.Action;
import org.apache.hugegraph.type.define.AggregateType;
import org.apache.hugegraph.type.define.Cardinality;
import org.apache.hugegraph.type.define.DataType;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.type.define.Frequency;
import org.apache.hugegraph.type.define.IdStrategy;
import org.apache.hugegraph.type.define.IndexType;
import org.apache.hugegraph.type.define.SchemaStatus;
import org.apache.hugegraph.util.CollectionUtil;
import org.apache.hugegraph.util.E;

public interface SerialEnum {
    public static final Map<Class, Map<Byte, SerialEnum>> table = new ConcurrentHashMap<Class, Map<Byte, SerialEnum>>();

    public byte code();

    public static void register(Class<? extends SerialEnum> clazz) {
        Object enums;
        try {
            enums = clazz.getMethod("values", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new HugeException("Exception in backend", e);
        }
        ConcurrentHashMap<Byte, SerialEnum> map = new ConcurrentHashMap<Byte, SerialEnum>();
        for (SerialEnum e : CollectionUtil.toList((Object)enums)) {
            map.put(e.code(), e);
        }
        table.put(clazz, map);
    }

    public static <T extends SerialEnum> T fromCode(Class<T> clazz, byte code) {
        Map<Byte, SerialEnum> clazzMap = table.get(clazz);
        if (clazzMap == null) {
            SerialEnum.register(clazz);
            clazzMap = table.get(clazz);
        }
        E.checkArgument((clazzMap != null ? 1 : 0) != 0, (String)"Can't get class registery for %s", (Object[])new Object[]{clazz.getSimpleName()});
        SerialEnum value = clazzMap.get(code);
        if (value == null) {
            E.checkArgument((boolean)false, (String)"Can't construct %s from code %s", (Object[])new Object[]{clazz.getSimpleName(), code});
        }
        return (T)value;
    }

    public static void registerInternalEnums() {
        SerialEnum.register(Action.class);
        SerialEnum.register(AggregateType.class);
        SerialEnum.register(Cardinality.class);
        SerialEnum.register(DataType.class);
        SerialEnum.register(Directions.class);
        SerialEnum.register(Frequency.class);
        SerialEnum.register(HugeType.class);
        SerialEnum.register(IdStrategy.class);
        SerialEnum.register(IndexType.class);
        SerialEnum.register(SchemaStatus.class);
    }
}

