/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client.grpc;

import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hugegraph.store.HgPageSize;
import org.apache.hugegraph.store.HgScanQuery;
import org.apache.hugegraph.store.HgSeekAble;
import org.apache.hugegraph.store.client.HgStoreNodeSession;
import org.apache.hugegraph.store.client.grpc.KvBatchUtil;
import org.apache.hugegraph.store.client.grpc.KvCloseableIterator;
import org.apache.hugegraph.store.grpc.common.Kv;
import org.apache.hugegraph.store.grpc.stream.HgStoreStreamGrpc;
import org.apache.hugegraph.store.grpc.stream.ScanStreamBatchReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
class KvBatchOneShotScanner
implements KvCloseableIterator<Kv>,
HgPageSize,
HgSeekAble {
    private static final Logger log = LoggerFactory.getLogger(KvBatchOneShotScanner.class);
    private final HgStoreNodeSession nodeSession;
    private final HgStoreStreamGrpc.HgStoreStreamBlockingStub stub;
    private final HgScanQuery scanQuery;
    private Iterator<Kv> iterator;
    private List<Kv> list = null;

    private KvBatchOneShotScanner(HgStoreNodeSession nodeSession, HgStoreStreamGrpc.HgStoreStreamBlockingStub stub, HgScanQuery scanQuery) {
        this.nodeSession = nodeSession;
        this.stub = stub;
        this.scanQuery = scanQuery;
    }

    public static KvCloseableIterator scan(HgStoreNodeSession nodeSession, HgStoreStreamGrpc.HgStoreStreamBlockingStub stub, HgScanQuery scanQuery) {
        return new KvBatchOneShotScanner(nodeSession, stub, scanQuery);
    }

    private ScanStreamBatchReq createReq() {
        return ScanStreamBatchReq.newBuilder().setHeader(KvBatchUtil.getHeader(this.nodeSession)).setQueryRequest(KvBatchUtil.createQueryReq(this.scanQuery, Integer.MAX_VALUE)).build();
    }

    private Iterator<Kv> createIterator() {
        this.list = this.stub.scanBatchOneShot(this.createReq()).getDataList();
        return this.list.iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.iterator == null) {
            this.iterator = this.createIterator();
        }
        return this.iterator.hasNext();
    }

    @Override
    public Kv next() {
        if (this.iterator == null) {
            this.iterator = this.createIterator();
        }
        return this.iterator.next();
    }

    @Override
    public long getPageSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isPageEmpty() {
        return !this.iterator.hasNext();
    }

    @Override
    public byte[] position() {
        return KvBatchUtil.EMPTY_POSITION;
    }

    @Override
    public void seek(byte[] position) {
    }

    @Override
    public void close() {
    }
}

