/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client.grpc;

import com.google.protobuf.ByteString;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hugegraph.store.HgOwnerKey;
import org.apache.hugegraph.store.HgPageSize;
import org.apache.hugegraph.store.HgSeekAble;
import org.apache.hugegraph.store.client.HgStoreNodeSession;
import org.apache.hugegraph.store.client.grpc.KvCloseableIterator;
import org.apache.hugegraph.store.client.util.HgStoreClientConfig;
import org.apache.hugegraph.store.client.util.HgStoreClientConst;
import org.apache.hugegraph.store.client.util.HgStoreClientUtil;
import org.apache.hugegraph.store.grpc.common.Header;
import org.apache.hugegraph.store.grpc.common.Kv;
import org.apache.hugegraph.store.grpc.common.ScanMethod;
import org.apache.hugegraph.store.grpc.stream.HgStoreStreamGrpc;
import org.apache.hugegraph.store.grpc.stream.ScanStreamReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
class KvOneShotScanner
implements KvCloseableIterator<Kv>,
HgPageSize,
HgSeekAble {
    private static final Logger log = LoggerFactory.getLogger(KvOneShotScanner.class);
    private static final HgStoreClientConfig storeClientConfig = HgStoreClientConfig.of();
    private final HgStoreNodeSession session;
    private final HgStoreStreamGrpc.HgStoreStreamBlockingStub stub;
    private final ScanStreamReq.Builder reqBuilder = ScanStreamReq.newBuilder();
    private final String table;
    private final HgOwnerKey startKey;
    private final HgOwnerKey endKey;
    private final HgOwnerKey prefix;
    private final ScanMethod scanMethod;
    private final long limit;
    private final int partition;
    private final int scanType;
    private final byte[] query;
    private final int pageSize;
    private ScanStreamReq req;
    private Iterator<Kv> iterator;
    private List<Kv> list = null;
    private boolean in = true;
    private byte[] nodePosition = HgStoreClientConst.EMPTY_BYTES;

    private KvOneShotScanner(ScanMethod scanMethod, HgStoreNodeSession session, HgStoreStreamGrpc.HgStoreStreamBlockingStub stub, String table, HgOwnerKey prefix, HgOwnerKey startKey, HgOwnerKey endKey, long limit, int partition, int scanType, byte[] query) {
        this.scanMethod = scanMethod;
        this.session = session;
        this.stub = stub;
        this.table = table;
        this.startKey = KvOneShotScanner.toOk(startKey);
        this.endKey = KvOneShotScanner.toOk(endKey);
        this.prefix = KvOneShotScanner.toOk(prefix);
        this.partition = partition;
        this.scanType = scanType;
        this.query = query != null ? query : HgStoreClientConst.EMPTY_BYTES;
        this.limit = limit <= 0L ? Integer.MAX_VALUE : limit;
        this.pageSize = storeClientConfig.getNetKvScannerPageSize();
    }

    public static KvCloseableIterator<Kv> scanAll(HgStoreNodeSession session, HgStoreStreamGrpc.HgStoreStreamBlockingStub stub, String table, long limit, byte[] query) {
        return new KvOneShotScanner(ScanMethod.ALL, session, stub, table, null, null, null, limit, -1, 128, query);
    }

    public static KvCloseableIterator<Kv> scanPrefix(HgStoreNodeSession session, HgStoreStreamGrpc.HgStoreStreamBlockingStub stub, String table, HgOwnerKey prefix, long limit, byte[] query) {
        return new KvOneShotScanner(ScanMethod.PREFIX, session, stub, table, prefix, null, null, limit, prefix.getKeyCode(), 1, query);
    }

    public static KvCloseableIterator<Kv> scanRange(HgStoreNodeSession nodeSession, HgStoreStreamGrpc.HgStoreStreamBlockingStub stub, String table, HgOwnerKey startKey, HgOwnerKey endKey, long limit, int scanType, byte[] query) {
        return new KvOneShotScanner(ScanMethod.RANGE, nodeSession, stub, table, null, startKey, endKey, limit, startKey.getKeyCode(), scanType, query);
    }

    static HgOwnerKey toOk(HgOwnerKey key) {
        return key == null ? HgStoreClientConst.EMPTY_OWNER_KEY : key;
    }

    static ByteString toBs(byte[] bytes) {
        return ByteString.copyFrom((byte[])(bytes != null ? bytes : HgStoreClientConst.EMPTY_BYTES));
    }

    private Header getHeader(HgStoreNodeSession nodeSession) {
        return Header.newBuilder().setGraph(nodeSession.getGraphName()).build();
    }

    private void createReq() {
        this.req = this.reqBuilder.setHeader(this.getHeader(this.session)).setMethod(this.scanMethod).setTable(this.table).setStart(KvOneShotScanner.toBs(this.startKey.getKey())).setEnd(KvOneShotScanner.toBs(this.endKey.getKey())).setLimit(this.limit).setPrefix(KvOneShotScanner.toBs(this.prefix.getKey())).setCode(this.partition).setScanType(this.scanType).setQuery(KvOneShotScanner.toBs(this.query)).setPageSize(this.pageSize).setPosition(KvOneShotScanner.toBs(this.nodePosition)).build();
    }

    private void init() {
        if (this.iterator == null) {
            this.createReq();
            this.list = this.stub.scanOneShot(this.req).getDataList();
            this.iterator = this.list.iterator();
        }
    }

    @Override
    public boolean hasNext() {
        if (!this.in) {
            return false;
        }
        if (this.iterator == null) {
            this.init();
        }
        return this.iterator.hasNext();
    }

    @Override
    public Kv next() {
        if (this.iterator == null) {
            this.init();
        }
        return this.iterator.next();
    }

    @Override
    public long getPageSize() {
        return this.limit;
    }

    @Override
    public boolean isPageEmpty() {
        return !this.iterator.hasNext();
    }

    @Override
    public byte[] position() {
        return HgStoreClientUtil.toBytes(this.session.getStoreNode().getNodeId());
    }

    @Override
    public void seek(byte[] position) {
        if (position == null || position.length < 8) {
            return;
        }
        byte[] nodeIdBytes = new byte[8];
        System.arraycopy(position, 0, nodeIdBytes, 0, 8);
        long nodeId = this.session.getStoreNode().getNodeId();
        long pId = HgStoreClientUtil.toLong(nodeIdBytes);
        boolean bl = this.in = nodeId >= pId;
        if (this.in && nodeId == pId) {
            this.nodePosition = new byte[position.length - 8];
            System.arraycopy(position, 8, this.nodePosition, 0, this.nodePosition.length);
        } else {
            this.nodePosition = HgStoreClientConst.EMPTY_BYTES;
        }
    }

    @Override
    public void close() {
    }
}

