/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client.grpc;

import com.google.protobuf.ByteString;
import org.apache.hugegraph.store.HgOwnerKey;
import org.apache.hugegraph.store.client.HgStoreNodeSession;
import org.apache.hugegraph.store.client.util.HgStoreClientConst;
import org.apache.hugegraph.store.grpc.common.Header;

public class ScanUtil {
    public static Header getHeader(HgStoreNodeSession nodeSession) {
        return Header.newBuilder().setGraph(nodeSession.getGraphName()).build();
    }

    public static HgOwnerKey toOk(HgOwnerKey key) {
        return key == null ? HgStoreClientConst.EMPTY_OWNER_KEY : key;
    }

    public static ByteString toBs(byte[] bytes) {
        return ByteString.copyFrom((byte[])(bytes != null ? bytes : HgStoreClientConst.EMPTY_BYTES));
    }

    public static ByteString getHgOwnerKey(HgOwnerKey ownerKey) {
        return ScanUtil.toBs(ScanUtil.toOk(ownerKey).getKey());
    }

    public static byte[] getQuery(byte[] query) {
        return query != null ? query : HgStoreClientConst.EMPTY_BYTES;
    }

    public static long getLimit(long limit) {
        return limit <= 0L ? Integer.MAX_VALUE : limit;
    }
}

