/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client.util;

import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;

public final class HgAssert {
    public static void isTrue(boolean expression, String message) {
        if (message == null) {
            throw new IllegalArgumentException("message is null");
        }
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isTrue(boolean expression, Supplier<String> msg) {
        if (msg == null) {
            throw new IllegalArgumentException("message supplier is null");
        }
        if (!expression) {
            throw new IllegalArgumentException(msg.get());
        }
    }

    public static void isFalse(boolean expression, String message) {
        HgAssert.isTrue(!expression, message);
    }

    public static void isFalse(boolean expression, Supplier<String> msg) {
        HgAssert.isTrue(!expression, msg);
    }

    public static void isArgumentValid(byte[] bytes, String parameter) {
        HgAssert.isFalse(HgAssert.isInvalid(bytes), () -> "The argument is invalid: " + parameter);
    }

    public static void isArgumentValid(String str, String parameter) {
        HgAssert.isFalse(HgAssert.isInvalid(str), () -> "The argument is invalid: " + parameter);
    }

    public static void isArgumentValid(Collection<?> collection, String parameter) {
        HgAssert.isFalse(HgAssert.isInvalid(collection), () -> "The argument is invalid: " + parameter);
    }

    public static void isArgumentNotNull(Object obj, String parameter) {
        HgAssert.isTrue(obj != null, () -> "The argument is null: " + parameter);
    }

    public static void istValid(byte[] bytes, String msg) {
        HgAssert.isFalse(HgAssert.isInvalid(bytes), msg);
    }

    public static void isValid(String str, String msg) {
        HgAssert.isFalse(HgAssert.isInvalid(str), msg);
    }

    public static void isNotNull(Object obj, String msg) {
        HgAssert.isTrue(obj != null, msg);
    }

    public static boolean isContains(Object[] objs, Object obj) {
        if (objs == null || objs.length == 0 || obj == null) {
            return false;
        }
        for (Object item : objs) {
            if (!obj.equals(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInvalid(String ... strs) {
        if (strs == null || strs.length == 0) {
            return true;
        }
        for (String item : strs) {
            if (item != null && !"".equals(item.trim())) continue;
            return true;
        }
        return false;
    }

    public static boolean isInvalid(byte[] bytes) {
        return bytes == null || bytes.length == 0;
    }

    public static boolean isInvalid(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isInvalid(Collection<?> list) {
        return list == null || list.isEmpty();
    }

    public static <T> boolean isContains(Collection<T> list, T item) {
        if (list == null || item == null) {
            return false;
        }
        return list.contains(item);
    }

    public static boolean isNull(Object ... objs) {
        if (objs == null) {
            return true;
        }
        for (Object item : objs) {
            if (item != null) continue;
            return true;
        }
        return false;
    }
}

