/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.filter;

import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http2.Http2Headers;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.common.store.SessionMode;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.core.exception.HttpRequestFilterException;
import org.apache.seata.core.rpc.netty.http.SimpleHttp2Request;
import org.apache.seata.core.rpc.netty.http.filter.HttpFilterContext;
import org.apache.seata.core.rpc.netty.http.filter.HttpRequestFilter;
import org.apache.seata.core.rpc.netty.http.filter.HttpRequestFilterChain;
import org.apache.seata.server.cluster.listener.ClusterChangeEvent;
import org.apache.seata.server.cluster.raft.context.SeataClusterContext;
import org.apache.seata.server.store.StoreConfig;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@LoadLevel(name="RaftRequest", order=1)
@Component
public class RaftRequestFilter
implements HttpRequestFilter,
ApplicationListener<ClusterChangeEvent> {
    private static final Map<String, Boolean> GROUP_PREVENT = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(HttpFilterContext<?> context, HttpRequestFilterChain chain) throws HttpRequestFilterException {
        String uri = this.getUri(context);
        if (!this.isTargetUri(uri)) {
            chain.doFilter(context);
            return;
        }
        String group = this.getGroup(context);
        if (group != null) {
            SeataClusterContext.bindGroup((String)group);
        }
        try {
            String method;
            if (context.getRequest() instanceof SimpleHttp2Request) {
                SimpleHttp2Request request = (SimpleHttp2Request)context.getRequest();
                method = request.getMethod().name();
            } else {
                HttpRequest request = (HttpRequest)context.getRequest();
                method = request.method().name();
            }
            if (!"GET".equalsIgnoreCase(method) && !this.isPass(group)) {
                throw new HttpRequestFilterException("The current TC is not a leader node, interrupt processing of transactions!");
            }
            chain.doFilter(context);
        }
        finally {
            SeataClusterContext.unbindGroup();
        }
    }

    private String getGroup(HttpFilterContext<?> context) {
        Map params = context.getParamWrapper().getAllParamsAsMultiMap();
        List unitParams = (List)params.get("unit");
        if (unitParams != null && !unitParams.isEmpty()) {
            return (String)unitParams.get(0);
        }
        if (context.getRequest() instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)context.getRequest();
            return httpRequest.headers().get("X-SEATA-RAFT-GROUP");
        }
        if (context.getRequest() instanceof SimpleHttp2Request) {
            Http2Headers http2Headers = ((SimpleHttp2Request)context.getRequest()).getHeaders();
            CharSequence headerValue = (CharSequence)http2Headers.get((Object)"X-SEATA-RAFT-GROUP");
            return headerValue != null ? headerValue.toString() : null;
        }
        return null;
    }

    public boolean shouldApply() {
        return StoreConfig.getSessionMode() == SessionMode.RAFT;
    }

    public void onApplicationEvent(ClusterChangeEvent event) {
        RaftRequestFilter.setPrevent((String)event.getGroup(), (boolean)event.isLeader());
    }

    public static void setPrevent(String group, boolean prevent) {
        if (StoreConfig.getSessionMode() == SessionMode.RAFT) {
            GROUP_PREVENT.put(group, prevent);
        }
    }

    private boolean isPass(String group) {
        return Optional.ofNullable((Boolean)GROUP_PREVENT.get(group)).orElse(false);
    }

    private String getUri(HttpFilterContext<?> context) {
        if (context.getRequest() instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)context.getRequest();
            return httpRequest.uri();
        }
        if (context.getRequest() instanceof SimpleHttp2Request) {
            return ((SimpleHttp2Request)context.getRequest()).getPath();
        }
        return null;
    }

    private boolean isTargetUri(String uri) {
        if (StringUtils.isBlank((String)uri)) {
            return false;
        }
        return uri.startsWith("/api/v1/console/") || uri.startsWith("/vgroup/v1/");
    }
}

