/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.method.prompt;

import io.modelcontextprotocol.common.McpTransportContext;
import io.modelcontextprotocol.server.McpAsyncServerExchange;
import io.modelcontextprotocol.server.McpSyncServerExchange;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springaicommunity.mcp.McpPredicates;
import org.springaicommunity.mcp.annotation.McpArg;
import org.springaicommunity.mcp.annotation.McpMeta;
import org.springaicommunity.mcp.annotation.McpProgressToken;
import org.springaicommunity.mcp.context.DefaultMcpAsyncRequestContext;
import org.springaicommunity.mcp.context.DefaultMcpSyncRequestContext;
import org.springaicommunity.mcp.context.McpAsyncRequestContext;
import org.springaicommunity.mcp.context.McpSyncRequestContext;

public abstract class AbstractMcpPromptMethodCallback {
    protected final Method method;
    protected final Object bean;
    protected final McpSchema.Prompt prompt;

    protected AbstractMcpPromptMethodCallback(Method method, Object bean, McpSchema.Prompt prompt) {
        this.method = method;
        this.bean = bean;
        this.prompt = prompt;
        this.validateMethod(this.method);
    }

    protected void validateMethod(Method method) {
        if (method == null) {
            throw new IllegalArgumentException("Method must not be null");
        }
        this.validateReturnType(method);
        this.validateParameters(method);
    }

    protected abstract void validateReturnType(Method var1);

    protected abstract boolean isSupportedExchangeOrContextType(Class<?> var1);

    protected void validateParamType(Class<?> paramType) {
    }

    protected void validateParameters(Method method) {
        Parameter[] parameters = method.getParameters();
        boolean hasExchangeParam = false;
        boolean hasRequestParam = false;
        boolean hasMapParam = false;
        boolean hasProgressTokenParam = false;
        boolean hasMetaParam = false;
        boolean hasRequestContextParam = false;
        for (Parameter param : parameters) {
            Class<?> paramType = param.getType();
            this.validateParamType(paramType);
            if (param.isAnnotationPresent(McpProgressToken.class)) {
                if (hasProgressTokenParam) {
                    throw new IllegalArgumentException("Method cannot have more than one @McpProgressToken parameter: " + method.getName() + " in " + method.getDeclaringClass().getName());
                }
                hasProgressTokenParam = true;
                continue;
            }
            if (McpMeta.class.isAssignableFrom(paramType)) {
                if (hasMetaParam) {
                    throw new IllegalArgumentException("Method cannot have more than one McpMeta parameter: " + method.getName() + " in " + method.getDeclaringClass().getName());
                }
                hasMetaParam = true;
                continue;
            }
            if (McpSyncRequestContext.class.isAssignableFrom(paramType)) {
                if (hasRequestContextParam) {
                    throw new IllegalArgumentException("Method cannot have more than one request context parameter: " + method.getName() + " in " + method.getDeclaringClass().getName());
                }
                if (McpPredicates.isReactiveReturnType.test(method)) {
                    throw new IllegalArgumentException("Sync complete methods should use McpSyncRequestContext instead of McpAsyncRequestContext parameter: " + method.getName() + " in " + method.getDeclaringClass().getName());
                }
                hasRequestContextParam = true;
                continue;
            }
            if (McpAsyncRequestContext.class.isAssignableFrom(paramType)) {
                if (hasRequestContextParam) {
                    throw new IllegalArgumentException("Method cannot have more than one request context parameter: " + method.getName() + " in " + method.getDeclaringClass().getName());
                }
                if (McpPredicates.isNotReactiveReturnType.test(method)) {
                    throw new IllegalArgumentException("Async complete methods should use McpAsyncRequestContext instead of McpSyncRequestContext parameter: " + method.getName() + " in " + method.getDeclaringClass().getName());
                }
                hasRequestContextParam = true;
                continue;
            }
            if (this.isSupportedExchangeOrContextType(paramType)) {
                if (hasExchangeParam) {
                    throw new IllegalArgumentException("Method cannot have more than one exchange parameter: " + method.getName() + " in " + method.getDeclaringClass().getName());
                }
                hasExchangeParam = true;
                continue;
            }
            if (McpSchema.GetPromptRequest.class.isAssignableFrom(paramType)) {
                if (hasRequestParam) {
                    throw new IllegalArgumentException("Method cannot have more than one GetPromptRequest parameter: " + method.getName() + " in " + method.getDeclaringClass().getName());
                }
                hasRequestParam = true;
                continue;
            }
            if (!Map.class.isAssignableFrom(paramType)) continue;
            if (hasMapParam) {
                throw new IllegalArgumentException("Method cannot have more than one Map parameter: " + method.getName() + " in " + method.getDeclaringClass().getName());
            }
            hasMapParam = true;
        }
    }

    protected abstract Object assignExchangeType(Class<?> var1, Object var2);

    protected Object[] buildArgs(Method method, Object exchange, McpSchema.GetPromptRequest request) {
        int i;
        Parameter[] parameters = method.getParameters();
        Object[] args = new Object[parameters.length];
        for (i = 0; i < parameters.length; ++i) {
            if (!parameters[i].isAnnotationPresent(McpProgressToken.class)) continue;
            args[i] = null;
        }
        for (i = 0; i < parameters.length; ++i) {
            if (!McpMeta.class.isAssignableFrom(parameters[i].getType())) continue;
            args[i] = request != null ? new McpMeta(request.meta()) : new McpMeta(null);
        }
        for (i = 0; i < parameters.length; ++i) {
            String paramName;
            if (args[i] != null || parameters[i].isAnnotationPresent(McpProgressToken.class) || McpMeta.class.isAssignableFrom(parameters[i].getType())) continue;
            Parameter param = parameters[i];
            Class<?> paramType = param.getType();
            if (McpTransportContext.class.isAssignableFrom(paramType) || McpSyncServerExchange.class.isAssignableFrom(paramType) || McpAsyncServerExchange.class.isAssignableFrom(paramType)) {
                args[i] = this.assignExchangeType(paramType, exchange);
                continue;
            }
            if (McpSyncRequestContext.class.isAssignableFrom(paramType)) {
                args[i] = DefaultMcpSyncRequestContext.builder().exchange((McpSyncServerExchange)exchange).request((McpSchema.Request)request).build();
                continue;
            }
            if (McpAsyncRequestContext.class.isAssignableFrom(paramType)) {
                args[i] = DefaultMcpAsyncRequestContext.builder().exchange((McpAsyncServerExchange)exchange).request((McpSchema.Request)request).build();
                continue;
            }
            if (McpSchema.GetPromptRequest.class.isAssignableFrom(paramType)) {
                args[i] = request;
                continue;
            }
            if (Map.class.isAssignableFrom(paramType)) {
                args[i] = request.arguments() != null ? request.arguments() : new HashMap();
                continue;
            }
            McpArg arg = param.getAnnotation(McpArg.class);
            String string = paramName = arg != null && !arg.name().isBlank() ? arg.name() : param.getName();
            if (request.arguments() != null && request.arguments().containsKey(paramName)) {
                Object argValue = request.arguments().get(paramName);
                args[i] = this.convertArgumentValue(argValue, paramType);
                continue;
            }
            args[i] = null;
        }
        return args;
    }

    protected Object convertArgumentValue(Object value, Class<?> targetType) {
        if (value == null) {
            return null;
        }
        if (targetType == String.class) {
            return value.toString();
        }
        if (targetType == Integer.class || targetType == Integer.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            return Integer.parseInt(value.toString());
        }
        if (targetType == Long.class || targetType == Long.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            return Long.parseLong(value.toString());
        }
        if (targetType == Double.class || targetType == Double.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            return Double.parseDouble(value.toString());
        }
        if (targetType == Boolean.class || targetType == Boolean.TYPE) {
            if (value instanceof Boolean) {
                return value;
            }
            return Boolean.parseBoolean(value.toString());
        }
        return value;
    }

    protected McpSchema.GetPromptResult convertToGetPromptResult(Object result) {
        if (result instanceof McpSchema.GetPromptResult) {
            return (McpSchema.GetPromptResult)result;
        }
        if (result instanceof List) {
            List list = (List)result;
            if (!list.isEmpty()) {
                if (list.get(0) instanceof McpSchema.PromptMessage) {
                    return new McpSchema.GetPromptResult(null, list);
                }
                if (list.get(0) instanceof String) {
                    List messages = list.stream().map(text -> new McpSchema.PromptMessage(McpSchema.Role.ASSISTANT, (McpSchema.Content)new McpSchema.TextContent(text))).collect(Collectors.toList());
                    return new McpSchema.GetPromptResult(null, messages);
                }
            }
        } else {
            if (result instanceof McpSchema.PromptMessage) {
                return new McpSchema.GetPromptResult(null, List.of((McpSchema.PromptMessage)result));
            }
            if (result instanceof String) {
                return new McpSchema.GetPromptResult(null, List.of(new McpSchema.PromptMessage(McpSchema.Role.ASSISTANT, (McpSchema.Content)new McpSchema.TextContent((String)result))));
            }
        }
        throw new IllegalArgumentException("Unsupported result type: " + (result != null ? result.getClass().getName() : "null"));
    }

    protected static abstract class AbstractBuilder<B extends AbstractBuilder<B, T>, T extends AbstractMcpPromptMethodCallback> {
        protected Method method;
        protected Object bean;
        protected McpSchema.Prompt prompt;

        protected AbstractBuilder() {
        }

        public B method(Method method) {
            this.method = method;
            return (B)this;
        }

        public B bean(Object bean) {
            this.bean = bean;
            return (B)this;
        }

        public B prompt(McpSchema.Prompt prompt) {
            this.prompt = prompt;
            return (B)this;
        }

        protected void validate() {
            Assert.notNull((Object)this.method, (String)"Method must not be null");
            Assert.notNull((Object)this.bean, (String)"Bean must not be null");
            Assert.notNull((Object)this.prompt, (String)"Prompt must not be null");
        }

        public abstract T build();
    }
}

