/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.common.util;

import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;

public class ConfigTools {
    public static KeyPair getKeyPair() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        return keyPair;
    }

    public static String getPublicKey(KeyPair keyPair) {
        PublicKey publicKey = keyPair.getPublic();
        byte[] bytes = publicKey.getEncoded();
        return ConfigTools.byte2Base64(bytes);
    }

    public static String getPrivateKey(KeyPair keyPair) {
        PrivateKey privateKey = keyPair.getPrivate();
        byte[] bytes = privateKey.getEncoded();
        return ConfigTools.byte2Base64(bytes);
    }

    public static PublicKey string2PublicKey(String pubStr) throws Exception {
        byte[] keyBytes = ConfigTools.base642Byte(pubStr);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey publicKey = keyFactory.generatePublic(keySpec);
        return publicKey;
    }

    public static PrivateKey string2PrivateKey(String priStr) throws Exception {
        byte[] keyBytes = ConfigTools.base642Byte(priStr);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
        return privateKey;
    }

    public static String publicEncrypt(String content, String pubStr) throws Exception {
        PublicKey publicKey = ConfigTools.string2PublicKey(pubStr);
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, publicKey);
        byte[] bytes = cipher.doFinal(content.getBytes());
        return ConfigTools.byte2Base64(bytes);
    }

    public static String publicDecrypt(String content, String pubStr) throws Exception {
        PublicKey publicKey = ConfigTools.string2PublicKey(pubStr);
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, publicKey);
        byte[] bytes = cipher.doFinal(ConfigTools.base642Byte(content));
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String privateEncrypt(String content, String priStr) throws Exception {
        PrivateKey privateKey = ConfigTools.string2PrivateKey(priStr);
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, privateKey);
        byte[] bytes = cipher.doFinal(content.getBytes());
        return ConfigTools.byte2Base64(bytes);
    }

    public static String privateDecrypt(String content, String priStr) throws Exception {
        PrivateKey privateKey = ConfigTools.string2PrivateKey(priStr);
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, privateKey);
        byte[] bytes = cipher.doFinal(ConfigTools.base642Byte(content));
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String byte2Base64(byte[] bytes) {
        return new String(Base64.getEncoder().encode(bytes), StandardCharsets.UTF_8);
    }

    public static byte[] base642Byte(String base64Key) {
        return Base64.getDecoder().decode(base64Key);
    }
}

