/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.optimize;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpLib;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.op.Op2;
import org.apache.jena.sparql.algebra.op.OpAssign;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpConditional;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpGroup;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpModifier;
import org.apache.jena.sparql.algebra.op.OpN;
import org.apache.jena.sparql.algebra.op.OpPath;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.algebra.op.OpSequence;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.algebra.op.OpUnion;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_SameTerm;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunction2;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;

public class TransformFilterEquality
extends TransformCopy {
    @Override
    public Op transform(OpFilter opFilter, Op subOp) {
        Op op = TransformFilterEquality.apply(opFilter.getExprs(), subOp);
        if (op == null) {
            return super.transform(opFilter, subOp);
        }
        return op;
    }

    private static Op apply(ExprList exprs, Op subOp) {
        Pair<List<Pair<Var, NodeValue>>, ExprList> p = TransformFilterEquality.preprocessFilterEquality(exprs);
        if (p == null || p.getLeft().size() == 0) {
            return null;
        }
        List<Pair<Var, NodeValue>> equalities = p.getLeft();
        Collection<Var> varsMentioned = TransformFilterEquality.varsMentionedInEqualityFilters(equalities);
        ExprList remaining = p.getRight();
        if (varsMentioned.size() < equalities.size()) {
            return null;
        }
        if (TransformFilterEquality.testSpecialCaseUnused(subOp, equalities, remaining)) {
            return null;
        }
        if (TransformFilterEquality.testSpecialCase1(subOp, equalities, remaining)) {
            List<Op> ops = TransformFilterEquality.extractOptionals(subOp);
            ops = TransformFilterEquality.processSpecialCase1(ops, equalities);
            Op op = TransformFilterEquality.rebuild((Op2)subOp, ops);
            op = OpFilter.filterBy(exprs, op);
            return op;
        }
        Op op = subOp;
        if (!TransformFilterEquality.safeToTransform(varsMentioned, op)) {
            return null;
        }
        for (Pair<Var, NodeValue> equalityTest : equalities) {
            op = TransformFilterEquality.processFilterWorker(op, equalityTest.getLeft(), equalityTest.getRight());
        }
        if (remaining.size() > 0) {
            op = OpFilter.filterBy(remaining, op);
        }
        return op;
    }

    private static Pair<List<Pair<Var, NodeValue>>, ExprList> preprocessFilterEquality(ExprList exprs) {
        ArrayList<Pair<Var, NodeValue>> exprsFilterEquality = new ArrayList<Pair<Var, NodeValue>>();
        ExprList exprsOther = new ExprList();
        for (Expr e2 : exprs.getList()) {
            Pair<Var, NodeValue> p = TransformFilterEquality.preprocess(e2);
            if (p != null) {
                exprsFilterEquality.add(p);
                continue;
            }
            exprsOther.add(e2);
        }
        if (exprsFilterEquality.size() == 0) {
            return null;
        }
        return Pair.create(exprsFilterEquality, exprsOther);
    }

    private static Pair<Var, NodeValue> preprocess(Expr e2) {
        if (!(e2 instanceof E_Equals) && !(e2 instanceof E_SameTerm)) {
            return null;
        }
        ExprFunction2 eq = (ExprFunction2)e2;
        Expr left = eq.getArg1();
        Expr right = eq.getArg2();
        Var var = null;
        NodeValue constant = null;
        if (left.isVariable() && right.isConstant()) {
            var = left.asVar();
            constant = right.getConstant();
        } else if (right.isVariable() && left.isConstant()) {
            var = right.asVar();
            constant = left.getConstant();
        }
        if (var == null || constant == null) {
            return null;
        }
        if (constant.isIRI() || constant.isBlank()) {
            return Pair.create(var, constant);
        }
        if (e2 instanceof E_SameTerm) {
            return Pair.create(var, constant);
        }
        Node n = constant.asNode();
        if (Util.isSimpleString(n)) {
            return Pair.create(var, constant);
        }
        return null;
    }

    private static Collection<Var> varsMentionedInEqualityFilters(List<Pair<Var, NodeValue>> equalities) {
        HashSet<Var> vars = new HashSet<Var>();
        for (Pair<Var, NodeValue> p : equalities) {
            vars.add(p.getLeft());
        }
        return vars;
    }

    private static boolean safeToTransform(Collection<Var> varsEquality, Op op) {
        OpTable opTable;
        if (op instanceof OpBGP || op instanceof OpQuadPattern) {
            return true;
        }
        if (op instanceof OpPath) {
            return true;
        }
        if (op instanceof OpFilter) {
            OpFilter opf = (OpFilter)op;
            return TransformFilterEquality.safeToTransform(varsEquality, opf.getSubOp());
        }
        if (op instanceof OpSequence) {
            OpN opN = (OpN)op;
            for (Op subOp : opN.getElements()) {
                if (TransformFilterEquality.safeToTransform(varsEquality, subOp)) continue;
                return false;
            }
            return true;
        }
        if (op instanceof OpJoin || op instanceof OpUnion) {
            Op2 op2 = (Op2)op;
            return TransformFilterEquality.safeToTransform(varsEquality, op2.getLeft()) && TransformFilterEquality.safeToTransform(varsEquality, op2.getRight());
        }
        if (op instanceof OpConditional || op instanceof OpLeftJoin) {
            Op2 opleftjoin = (Op2)op;
            if (!TransformFilterEquality.safeToTransform(varsEquality, opleftjoin.getLeft()) || !TransformFilterEquality.safeToTransform(varsEquality, opleftjoin.getRight())) {
                return false;
            }
            Op opLeft = opleftjoin.getLeft();
            Set<Var> varsLeft = OpVars.visibleVars(opLeft);
            return varsLeft.containsAll(varsEquality);
        }
        if (op instanceof OpGraph) {
            OpGraph opg = (OpGraph)op;
            return TransformFilterEquality.safeToTransform(varsEquality, opg.getSubOp());
        }
        if (op instanceof OpModifier) {
            OpModifier opMod = (OpModifier)op;
            if (opMod instanceof OpProject) {
                OpProject opProject = (OpProject)op;
                for (Var v : opProject.getVars()) {
                    if (!varsEquality.contains(v)) continue;
                    return false;
                }
            }
            return TransformFilterEquality.safeToTransform(varsEquality, opMod.getSubOp());
        }
        if (op instanceof OpGroup) {
            OpGroup opGroup = (OpGroup)op;
            VarExprList varExprList = opGroup.getGroupVars();
            return TransformFilterEquality.safeToTransform(varsEquality, varExprList) && TransformFilterEquality.safeToTransform(varsEquality, opGroup.getSubOp());
        }
        return op instanceof OpTable && (opTable = (OpTable)op).isJoinIdentity();
    }

    private static boolean safeToTransform(Collection<Var> varsEquality, VarExprList varsExprList) {
        return Collections.disjoint(varsExprList.getVars(), varsEquality);
    }

    private static boolean testSpecialCaseUnused(Op op, List<Pair<Var, NodeValue>> equalities, ExprList remaining) {
        Set<Var> patternVars = OpVars.visibleVars(op);
        for (Pair<Var, NodeValue> p : equalities) {
            if (patternVars.contains(p.getLeft())) continue;
            return true;
        }
        return false;
    }

    private static boolean testSpecialCase1(Op op, List<Pair<Var, NodeValue>> equalities, ExprList remaining) {
        while (op instanceof OpConditional || op instanceof OpLeftJoin) {
            Op2 opleftjoin2 = (Op2)op;
            op = opleftjoin2.getLeft();
        }
        return TransformFilterEquality.isUnitTable(op);
    }

    private static List<Op> extractOptionals(Op op) {
        ArrayList<Op> chain = new ArrayList<Op>();
        while (op instanceof OpConditional || op instanceof OpLeftJoin) {
            Op2 opleftjoin2 = (Op2)op;
            chain.add(opleftjoin2.getRight());
            op = opleftjoin2.getLeft();
        }
        return chain;
    }

    private static List<Op> processSpecialCase1(List<Op> ops, List<Pair<Var, NodeValue>> equalities) {
        ArrayList<Op> ops2 = new ArrayList<Op>();
        Collection<Var> vars = TransformFilterEquality.varsMentionedInEqualityFilters(equalities);
        Iterator<Op> iterator = ops.iterator();
        while (iterator.hasNext()) {
            Op op;
            Op op2 = op = iterator.next();
            if (TransformFilterEquality.safeToTransform(vars, op)) {
                for (Pair<Var, NodeValue> p : equalities) {
                    op2 = TransformFilterEquality.processFilterWorker(op, p.getLeft(), p.getRight());
                }
            }
            ops2.add(op2);
        }
        return ops2;
    }

    private static Op rebuild(Op2 subOp, List<Op> ops) {
        Op chain = OpLib.unit();
        for (Op op : ops) {
            chain = subOp.copy(chain, op);
        }
        return chain;
    }

    private static boolean isUnitTable(Op op) {
        return op instanceof OpTable && ((OpTable)op).isJoinIdentity();
    }

    private static Op processFilterWorker(Op op, Var var, NodeValue constant) {
        return TransformFilterEquality.subst(op, var, constant);
    }

    private static Op subst(Op subOp, Var var, NodeValue nv) {
        Op op = Substitute.substitute(subOp, var, nv.asNode());
        return OpAssign.assign(op, var, nv);
    }

    static Op processFilter(Expr e2, Op subOp) {
        return TransformFilterEquality.apply(new ExprList(e2), subOp);
    }
}

