/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.GraphBase;
import org.apache.jena.mem.GraphMem;
import org.apache.jena.mem2.GraphMem2Fast;
import org.apache.jena.mem2.GraphMem2Legacy;
import org.apache.jena.mem2.GraphMem2Roaring;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;

public class GraphMemFactory {
    private static boolean defaultSameTerm;
    private static final Graph emptyGraph;

    private GraphMemFactory() {
    }

    @Deprecated(forRemoval=true)
    public static void setDftGraphSameTerm(boolean value) {
        defaultSameTerm = value;
    }

    @Deprecated(forRemoval=true)
    public static boolean dftGraphSameTerm() {
        return defaultSameTerm;
    }

    public static Graph createDefaultGraph() {
        return GraphMemFactory.dftGraphSameTerm() ? GraphMemFactory.createDefaultGraphSameTerm() : GraphMemFactory.createDefaultGraphSameValue();
    }

    @Deprecated(forRemoval=true)
    public static Graph createGraphMem() {
        return GraphMemFactory.createGraphMem2();
    }

    public static Graph createGraphMemForModel() {
        GraphMem g = new GraphMem();
        return g;
    }

    public static Graph createDefaultGraphSameValue() {
        GraphMem g = new GraphMem();
        return g;
    }

    public static Graph createDefaultGraphSameTerm() {
        return GraphMemFactory.createGraphMem2();
    }

    public static Graph createGraphMemBasic() {
        return new GraphMem2Legacy();
    }

    @Deprecated(forRemoval=true)
    public static Graph createGraphMem2Basic() {
        return GraphMemFactory.createGraphMemBasic();
    }

    public static Graph createGraphMem2() {
        return new GraphMem2Fast();
    }

    public static Graph createGraphMemRoaring() {
        return new GraphMem2Roaring();
    }

    @Deprecated(forRemoval=true)
    public static Graph createGraphMem2Roaring() {
        return GraphMemFactory.createGraphMemRoaring();
    }

    public static Graph empty() {
        return emptyGraph;
    }

    static {
        JenaSystem.init();
        defaultSameTerm = true;
        String x = System.getProperty("jena:graphSameTerm");
        if (x != null) {
            if (x.equalsIgnoreCase("true")) {
                defaultSameTerm = true;
            }
            if (x.equalsIgnoreCase("false")) {
                defaultSameTerm = false;
            }
        }
        emptyGraph = new GraphBase(){

            @Override
            protected ExtendedIterator<Triple> graphBaseFind(Triple triplePattern) {
                return NullIterator.instance();
            }
        };
    }
}

