/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.log.core.internal;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import org.apache.karaf.log.core.Level;
import org.apache.karaf.log.core.internal.LogServiceInternal;

public class LogServiceLog4j1Impl
implements LogServiceInternal {
    static final String ROOT_LOGGER_PREFIX = "log4j.rootLogger";
    static final String LOGGER_PREFIX = "log4j.logger.";
    private final Dictionary<String, Object> config;

    public LogServiceLog4j1Impl(Dictionary<String, Object> config) {
        this.config = config;
    }

    @Override
    public Map<String, String> getLevel(String logger) {
        String val;
        TreeMap<String, String> loggers = new TreeMap<String, String>();
        if ("ROOT".equalsIgnoreCase(logger)) {
            logger = null;
        }
        if ("ALL".equalsIgnoreCase(logger)) {
            String root = this.getLevelFromProperty((String)this.config.get(ROOT_LOGGER_PREFIX));
            loggers.put("ROOT", root);
            Enumeration<String> e = this.config.keys();
            while (e.hasMoreElements()) {
                String prop = e.nextElement();
                if (!prop.startsWith(LOGGER_PREFIX)) continue;
                String val2 = this.getLevelFromProperty((String)this.config.get(prop));
                loggers.put(prop.substring(LOGGER_PREFIX.length()), val2);
            }
            return loggers;
        }
        String l = logger;
        while (true) {
            Object prop = l == null ? ROOT_LOGGER_PREFIX : LOGGER_PREFIX + l;
            val = (String)this.config.get(prop);
            if ((val = this.getLevelFromProperty(val)) != null || l == null) break;
            int idx = l.lastIndexOf(46);
            if (idx < 0) {
                l = null;
                continue;
            }
            l = l.substring(0, idx);
        }
        if (logger == null) {
            logger = "ROOT";
        }
        loggers.put(logger, val);
        return loggers;
    }

    @Override
    public void setLevel(String logger, String level) {
        Object prop = logger == null || "ROOT".equalsIgnoreCase(logger) ? ROOT_LOGGER_PREFIX : LOGGER_PREFIX + logger;
        Object val = (String)this.config.get(prop);
        if (Level.isDefault(level)) {
            if (val != null) {
                int idx = ((String)(val = ((String)val).trim())).indexOf(",");
                val = idx < 0 ? null : ((String)val).substring(idx);
            }
        } else {
            int idx;
            val = val == null ? level : ((idx = ((String)(val = ((String)val).trim())).indexOf(",")) < 0 ? level : level + ((String)val).substring(idx));
        }
        if (val == null) {
            this.config.remove(prop);
        } else {
            this.config.put((String)prop, val);
        }
    }

    private String getLevelFromProperty(String prop) {
        if (prop == null) {
            return null;
        }
        String val = prop.trim();
        int idx = val.indexOf(",");
        if (idx == 0) {
            val = null;
        } else if (idx > 0) {
            val = val.substring(0, idx);
        }
        return val;
    }
}

