/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.lang.reflect.Method;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.impl.converter.CachingInjector;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.TypeConverterSupport;

public class InstanceMethodFallbackTypeConverter
extends TypeConverterSupport {
    private final CachingInjector<?> injector;
    private final Method method;
    private final boolean useExchange;
    private final TypeConverterRegistry registry;
    private final boolean allowNull;

    public InstanceMethodFallbackTypeConverter(CachingInjector<?> injector, Method method, TypeConverterRegistry registry, boolean allowNull) {
        this.injector = injector;
        this.method = method;
        this.useExchange = method.getParameterCount() == 4;
        this.registry = registry;
        this.allowNull = allowNull;
    }

    public String toString() {
        return "InstanceMethodFallbackTypeConverter: " + this.method;
    }

    public boolean allowNull() {
        return this.allowNull;
    }

    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
        Object instance = this.injector.newInstance();
        if (instance == null) {
            throw new RuntimeCamelException("Could not instantiate an instance of: " + type.getCanonicalName());
        }
        return (T)(this.useExchange ? ObjectHelper.invokeMethod((Method)this.method, instance, (Object[])new Object[]{type, exchange, value, this.registry}) : ObjectHelper.invokeMethod((Method)this.method, instance, (Object[])new Object[]{type, value, this.registry}));
    }
}

