/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Producer;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.support.EventNotifierSupport;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishEventNotifier
extends EventNotifierSupport
implements CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(PublishEventNotifier.class);
    private CamelContext camelContext;
    private Endpoint endpoint;
    private String endpointUri;
    private Producer producer;

    public void notify(CamelEvent event) throws Exception {
        if (!this.isStarted()) {
            LOG.debug("Cannot publish event as notifier is not started: {}", (Object)event);
            return;
        }
        if (!this.camelContext.getStatus().isStarted()) {
            LOG.debug("Cannot publish event as CamelContext is not started: {}", (Object)event);
            return;
        }
        Exchange exchange = this.producer.getEndpoint().createExchange();
        exchange.getIn().setBody((Object)event);
        ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).setNotifyEvent(true);
        try {
            this.producer.process(exchange);
        }
        finally {
            ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).setNotifyEvent(false);
        }
    }

    public boolean isEnabled(CamelEvent event) {
        return true;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public String getEndpointUri() {
        return this.endpointUri;
    }

    public void setEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"camelContext", (Object)((Object)this));
        if (this.endpoint == null && this.endpointUri == null) {
            throw new IllegalArgumentException("Either endpoint or endpointUri must be configured");
        }
        if (this.endpoint == null) {
            this.endpoint = this.camelContext.getEndpoint(this.endpointUri);
        }
        this.producer = this.endpoint.createProducer();
        ServiceHelper.startService((Object)this.producer);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.producer);
    }

    public String toString() {
        return "PublishEventNotifier[" + (this.endpoint != null ? this.endpoint : URISupport.sanitizeUri((String)this.endpointUri)) + "]";
    }
}

