/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedErrorHandlerMBean;
import org.apache.camel.processor.errorhandler.ErrorHandlerSupport;
import org.apache.camel.processor.errorhandler.RedeliveryErrorHandler;
import org.apache.camel.spi.ManagementStrategy;

@ManagedResource(description="Managed ErrorHandler")
public class ManagedErrorHandler
implements ManagedErrorHandlerMBean {
    private final Route route;
    private final Processor errorHandler;
    private final ErrorHandlerFactory errorHandlerBuilder;

    public ManagedErrorHandler(Route route, Processor errorHandler, ErrorHandlerFactory builder) {
        this.route = route;
        this.errorHandler = errorHandler;
        this.errorHandlerBuilder = builder;
    }

    public void init(ManagementStrategy strategy) {
    }

    public Route getRoute() {
        return this.route;
    }

    public Processor getErrorHandler() {
        return this.errorHandler;
    }

    public ErrorHandlerFactory getErrorHandlerBuilder() {
        return this.errorHandlerBuilder;
    }

    public String getCamelId() {
        return this.route.getCamelContext().getName();
    }

    public String getCamelManagementName() {
        return this.route.getCamelContext().getManagementName();
    }

    public boolean isSupportRedelivery() {
        return this.errorHandler instanceof RedeliveryErrorHandler;
    }

    public boolean isDeadLetterChannel() {
        if (!this.isSupportRedelivery()) {
            return false;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getDeadLetter() != null;
    }

    public boolean isDeadLetterUseOriginalMessage() {
        if (!this.isSupportRedelivery()) {
            return false;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.isUseOriginalMessagePolicy();
    }

    public boolean isDeadLetterUseOriginalBody() {
        if (!this.isSupportRedelivery()) {
            return false;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.isUseOriginalBodyPolicy();
    }

    public boolean isDeadLetterHandleNewException() {
        if (!this.isSupportRedelivery()) {
            return false;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return this.isDeadLetterChannel() && redelivery.isDeadLetterHandleNewException();
    }

    public boolean isSupportTransactions() {
        if (this.errorHandler instanceof ErrorHandlerSupport) {
            ErrorHandlerSupport ehs = (ErrorHandlerSupport)this.errorHandler;
            return ehs.supportTransacted();
        }
        return false;
    }

    public String getDeadLetterChannelEndpointUri() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getDeadLetterUri();
    }

    public Integer getMaximumRedeliveries() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().getMaximumRedeliveries();
    }

    public void setMaximumRedeliveries(Integer maximum) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setMaximumRedeliveries(maximum.intValue());
    }

    public Long getMaximumRedeliveryDelay() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().getMaximumRedeliveryDelay();
    }

    public void setMaximumRedeliveryDelay(Long delay) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setMaximumRedeliveryDelay(delay.longValue());
    }

    public Long getRedeliveryDelay() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().getRedeliveryDelay();
    }

    public void setRedeliveryDelay(Long delay) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setRedeliveryDelay(delay.longValue());
    }

    public Double getBackOffMultiplier() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().getBackOffMultiplier();
    }

    public void setBackOffMultiplier(Double multiplier) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setBackOffMultiplier(multiplier.doubleValue());
    }

    public Double getCollisionAvoidanceFactor() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().getCollisionAvoidanceFactor();
    }

    public void setCollisionAvoidanceFactor(Double factor) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setCollisionAvoidanceFactor(factor.doubleValue());
    }

    public Double getCollisionAvoidancePercent() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().getCollisionAvoidancePercent();
    }

    public void setCollisionAvoidancePercent(Double percent) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setCollisionAvoidancePercent(percent.doubleValue());
    }

    public String getDelayPattern() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().getDelayPattern();
    }

    public void setDelayPattern(String pattern) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setDelayPattern(pattern);
    }

    public String getRetriesExhaustedLogLevel() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().getRetriesExhaustedLogLevel().name();
    }

    public void setRetriesExhaustedLogLevel(String level) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setRetriesExhaustedLogLevel(LoggingLevel.valueOf((String)level));
    }

    public String getRetryAttemptedLogLevel() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().getRetryAttemptedLogLevel().name();
    }

    public void setRetryAttemptedLogLevel(String level) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setRetryAttemptedLogLevel(LoggingLevel.valueOf((String)level));
    }

    public Boolean getLogStackTrace() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().isLogStackTrace();
    }

    public void setLogStackTrace(Boolean log) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setLogStackTrace(log.booleanValue());
    }

    public Boolean getLogRetryStackTrace() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().isLogRetryStackTrace();
    }

    public void setLogRetryStackTrace(Boolean log) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setLogRetryStackTrace(log.booleanValue());
    }

    public Boolean getLogHandled() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().isLogHandled();
    }

    public void setLogHandled(Boolean log) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setLogHandled(log.booleanValue());
    }

    public Boolean getLogNewException() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().isLogNewException();
    }

    public void setLogNewException(Boolean log) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setLogNewException(log.booleanValue());
    }

    public Boolean getLogExhaustedMessageHistory() {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().isLogExhaustedMessageHistory();
    }

    public void setLogExhaustedMessageHistory(Boolean log) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setLogExhaustedMessageHistory(log.booleanValue());
    }

    public Boolean getLogExhaustedMessageBody() {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().isLogExhaustedMessageBody();
    }

    public void setLogExhaustedMessageBody(Boolean log) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setLogExhaustedMessageBody(log);
    }

    public Boolean getLogContinued() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().isLogHandled();
    }

    public void setLogContinued(Boolean log) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setLogContinued(log.booleanValue());
    }

    public Boolean getLogExhausted() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().isLogExhausted();
    }

    public void setLogExhausted(Boolean log) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setLogExhausted(log.booleanValue());
    }

    public Boolean getUseCollisionAvoidance() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().isUseCollisionAvoidance();
    }

    public void setUseCollisionAvoidance(Boolean avoidance) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setUseCollisionAvoidance(avoidance.booleanValue());
    }

    public Boolean getUseExponentialBackOff() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().isUseExponentialBackOff();
    }

    public void setUseExponentialBackOff(Boolean backoff) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setUseExponentialBackOff(backoff.booleanValue());
    }

    public Boolean getAllowRedeliveryWhileStopping() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().isAllowRedeliveryWhileStopping();
    }

    public void setAllowRedeliveryWhileStopping(Boolean allow) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setAllowRedeliveryWhileStopping(allow.booleanValue());
    }

    public Integer getPendingRedeliveryCount() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getPendingRedeliveryCount();
    }
}

