/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.audit;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.apache.karaf.jaas.modules.JAASUtils;
import org.apache.karaf.jaas.modules.audit.AbstractAuditLoginModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogAuditLoginModule
extends AbstractAuditLoginModule {
    public static final String LOG_LEVEL_OPTION = "level";
    public static final String LOG_LOGGER_OPTION = "logger";
    private String level = "INFO";
    private Logger logger;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.level = JAASUtils.getString(options, LOG_LEVEL_OPTION);
        this.logger = LoggerFactory.getLogger((String)JAASUtils.getString(options, LOG_LOGGER_OPTION));
    }

    @Override
    protected synchronized void audit(AbstractAuditLoginModule.Action action, String username) {
        String actionStr;
        switch (action) {
            case ATTEMPT: {
                actionStr = "Authentication attempt";
                break;
            }
            case SUCCESS: {
                actionStr = "Authentication succeeded";
                break;
            }
            case FAILURE: {
                actionStr = "Authentication failed";
                break;
            }
            case LOGOUT: {
                actionStr = "Explicit logout";
                break;
            }
            default: {
                actionStr = action.toString();
            }
        }
        if (this.level.equalsIgnoreCase("debug")) {
            this.logger.debug("{} - {} - {}", new Object[]{actionStr, username, this.getPrincipalInfo()});
        } else if (this.level.equalsIgnoreCase("trace")) {
            this.logger.trace("{} - {} - {}", new Object[]{actionStr, username, this.getPrincipalInfo()});
        } else if (this.level.equalsIgnoreCase("warn")) {
            this.logger.warn("{} - {} - {}", new Object[]{actionStr, username, this.getPrincipalInfo()});
        } else if (this.level.equalsIgnoreCase("error")) {
            this.logger.error("{} - {} - {}", new Object[]{actionStr, username, this.getPrincipalInfo()});
        } else {
            this.logger.info("{} - {} - {}", new Object[]{actionStr, username, this.getPrincipalInfo()});
        }
    }
}

