/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene104;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.lucene104.Lucene104ScalarQuantizedVectorsFormat;
import org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsReader;
import org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsWriter;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.search.TaskExecutor;

public class Lucene104HnswScalarQuantizedVectorsFormat
extends KnnVectorsFormat {
    public static final String NAME = "Lucene104HnswBinaryQuantizedVectorsFormat";
    private final int maxConn;
    private final int beamWidth;
    private final Lucene104ScalarQuantizedVectorsFormat flatVectorsFormat;
    private final int tinySegmentsThreshold;
    private final int numMergeWorkers;
    private final TaskExecutor mergeExec;

    public Lucene104HnswScalarQuantizedVectorsFormat() {
        this(Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding.UNSIGNED_BYTE, 16, 100, 1, null, 100);
    }

    public Lucene104HnswScalarQuantizedVectorsFormat(int maxConn, int beamWidth) {
        this(Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding.UNSIGNED_BYTE, maxConn, beamWidth, 1, null, 100);
    }

    public Lucene104HnswScalarQuantizedVectorsFormat(Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding encoding, int maxConn, int beamWidth) {
        this(encoding, maxConn, beamWidth, 1, null, 100);
    }

    public Lucene104HnswScalarQuantizedVectorsFormat(Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding encoding, int maxConn, int beamWidth, int numMergeWorkers, ExecutorService mergeExec) {
        this(encoding, maxConn, beamWidth, numMergeWorkers, mergeExec, 100);
    }

    public Lucene104HnswScalarQuantizedVectorsFormat(Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding encoding, int maxConn, int beamWidth, int numMergeWorkers, ExecutorService mergeExec, int tinySegmentsThreshold) {
        super(NAME);
        this.flatVectorsFormat = new Lucene104ScalarQuantizedVectorsFormat(encoding);
        if (maxConn <= 0 || maxConn > 512) {
            throw new IllegalArgumentException("maxConn must be positive and less than or equal to 512; maxConn=" + maxConn);
        }
        if (beamWidth <= 0 || beamWidth > 3200) {
            throw new IllegalArgumentException("beamWidth must be positive and less than or equal to 3200; beamWidth=" + beamWidth);
        }
        this.maxConn = maxConn;
        this.beamWidth = beamWidth;
        this.tinySegmentsThreshold = tinySegmentsThreshold;
        if (numMergeWorkers == 1 && mergeExec != null) {
            throw new IllegalArgumentException("No executor service is needed as we'll use single thread to merge");
        }
        this.numMergeWorkers = numMergeWorkers;
        this.mergeExec = mergeExec != null ? new TaskExecutor(mergeExec) : null;
    }

    @Override
    public KnnVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new Lucene99HnswVectorsWriter(state, this.maxConn, this.beamWidth, this.flatVectorsFormat.fieldsWriter(state), this.numMergeWorkers, this.mergeExec, this.tinySegmentsThreshold);
    }

    @Override
    public KnnVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return new Lucene99HnswVectorsReader(state, this.flatVectorsFormat.fieldsReader(state));
    }

    @Override
    public int getMaxDimensions(String fieldName) {
        return 1024;
    }

    public String toString() {
        return "Lucene104HnswScalarQuantizedVectorsFormat(name=Lucene104HnswScalarQuantizedVectorsFormat, maxConn=" + this.maxConn + ", beamWidth=" + this.beamWidth + ", tinySegmentsThreshold=" + this.tinySegmentsThreshold + ", flatVectorFormat=" + String.valueOf(this.flatVectorsFormat) + ")";
    }
}

