/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.mockfile;

import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemException;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.tests.mockfile.HandleTrackingFS;

public class HandleLimitFS
extends HandleTrackingFS {
    final int limit;
    final AtomicInteger count = new AtomicInteger();

    public HandleLimitFS(FileSystem delegate, int limit) {
        super("handlelimit://", delegate);
        this.limit = limit;
    }

    @Override
    protected void onOpen(Path path, Object stream) throws IOException {
        if (this.count.incrementAndGet() > this.limit) {
            this.count.decrementAndGet();
            throw new FileSystemException(path.toString(), null, "Too many open files");
        }
    }

    @Override
    protected void onClose(Path path, Object stream) throws IOException {
        this.count.decrementAndGet();
    }

    @Documented
    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface MaxOpenHandles {
        public static final int MAX_OPEN_FILES = 2048;

        public int limit();
    }
}

