/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.concurrency;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;

public interface SmartExecutor
extends AutoCloseable {
    public void submit(Runnable var1);

    public <T> Future<T> submit(Callable<T> var1);

    @Override
    public void close();

    public static class NonClosing
    implements SmartExecutor {
        private final SmartExecutor smartExecutor;

        NonClosing(SmartExecutor smartExecutor) {
            this.smartExecutor = smartExecutor;
        }

        @Override
        public void submit(Runnable runnable) {
            this.smartExecutor.submit(runnable);
        }

        @Override
        public <T> Future<T> submit(Callable<T> callable) {
            return this.smartExecutor.submit(callable);
        }

        @Override
        public void close() {
        }
    }

    public static class Limited
    implements SmartExecutor {
        private final SmartExecutor executor;
        private final Semaphore semaphore;

        Limited(SmartExecutor executor, int limit) {
            this.executor = executor;
            this.semaphore = new Semaphore(limit);
        }

        @Override
        public void submit(Runnable runnable) {
            try {
                this.semaphore.acquire();
                this.executor.submit(() -> {
                    try {
                        runnable.run();
                    }
                    finally {
                        this.semaphore.release();
                    }
                });
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public <T> Future<T> submit(Callable<T> callable) {
            try {
                this.semaphore.acquire();
                CompletableFuture future = new CompletableFuture();
                this.executor.submit(() -> {
                    try {
                        future.complete(callable.call());
                    }
                    catch (Exception e) {
                        future.completeExceptionally(e);
                    }
                    finally {
                        this.semaphore.release();
                    }
                });
                return future;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                CompletableFuture failed = new CompletableFuture();
                failed.completeExceptionally(e);
                return failed;
            }
        }

        @Override
        public void close() {
            this.executor.close();
        }
    }

    public static class Pooled
    implements SmartExecutor {
        private final ExecutorService executor;

        Pooled(ExecutorService executor) {
            this.executor = executor;
        }

        @Override
        public void submit(Runnable runnable) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            this.executor.submit(() -> {
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(tccl);
                try {
                    runnable.run();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                }
            });
        }

        @Override
        public <T> Future<T> submit(Callable<T> callable) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            CompletableFuture future = new CompletableFuture();
            this.executor.submit(() -> {
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(tccl);
                try {
                    future.complete(callable.call());
                }
                catch (Exception e) {
                    future.completeExceptionally(e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                }
            });
            return future;
        }

        @Override
        public void close() {
            this.executor.shutdown();
        }
    }

    public static class Direct
    implements SmartExecutor {
        @Override
        public void submit(Runnable runnable) {
            runnable.run();
        }

        public <T> CompletableFuture<T> submit(Callable<T> callable) {
            CompletableFuture<T> future = new CompletableFuture<T>();
            try {
                future.complete(callable.call());
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
            return future;
        }

        @Override
        public void close() {
        }
    }
}

