/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.runtime;

import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.util.Objects;
import org.apache.nifi.NiFiServer;
import org.apache.nifi.runtime.HealthClusterHttpHandler;
import org.apache.nifi.runtime.HealthDiagnosticsHttpHandler;
import org.apache.nifi.runtime.HealthHttpHandler;
import org.apache.nifi.runtime.HealthStatusHistoryHttpHandler;
import org.apache.nifi.runtime.ManagementServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardManagementServer
implements ManagementServer {
    private static final Logger logger = LoggerFactory.getLogger(StandardManagementServer.class);
    private static final String HEALTH_PATH = "/health";
    private static final String HEALTH_CLUSTER_PATH = "/health/cluster";
    private static final String HEALTH_DIAGNOSTICS_PATH = "/health/diagnostics";
    private static final String HEALTH_STATUS_HISTORY_PATH = "/health/status-history";
    private static final int STOP_DELAY = 0;
    private static final int CONNECTION_BACKLOG = 10;
    private final InetSocketAddress bindAddress;
    private final NiFiServer server;
    private HttpServer httpServer;

    public StandardManagementServer(InetSocketAddress bindAddress, NiFiServer server) {
        this.bindAddress = Objects.requireNonNull(bindAddress, "Bind Address required");
        this.server = Objects.requireNonNull(server, "Server required");
    }

    @Override
    public void start() {
        if (this.httpServer == null) {
            try {
                this.httpServer = HttpServer.create();
                this.httpServer.createContext(HEALTH_PATH, new HealthHttpHandler());
                this.httpServer.createContext(HEALTH_CLUSTER_PATH, new HealthClusterHttpHandler(this.server));
                this.httpServer.createContext(HEALTH_DIAGNOSTICS_PATH, new HealthDiagnosticsHttpHandler(this.server));
                this.httpServer.createContext(HEALTH_STATUS_HISTORY_PATH, new HealthStatusHistoryHttpHandler(this.server));
                this.httpServer.bind(this.bindAddress, 10);
                this.httpServer.start();
                InetSocketAddress serverAddress = this.getServerAddress();
                logger.info("Started Management Server on http://{}:{}", (Object)serverAddress.getHostString(), (Object)serverAddress.getPort());
            }
            catch (IOException e) {
                throw new UncheckedIOException("Management Server start failed", e);
            }
        } else {
            throw new IllegalStateException("Management Server running");
        }
    }

    @Override
    public void stop() {
        if (this.httpServer == null) {
            logger.info("Management Server not running");
        } else {
            this.httpServer.stop(0);
            logger.info("Management Server stopped");
        }
    }

    protected InetSocketAddress getServerAddress() {
        return this.httpServer == null ? this.bindAddress : this.httpServer.getAddress();
    }
}

