/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.callback;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.flywaydb.core.FlywayTelemetryManager;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.callback.CallbackEvent;
import org.flywaydb.core.api.callback.Context;
import org.flywaydb.core.api.callback.Error;
import org.flywaydb.core.api.callback.GenericCallback;
import org.flywaydb.core.api.callback.Warning;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.exception.FlywayBlockStatementExecutionException;
import org.flywaydb.core.api.output.OperationResult;
import org.flywaydb.core.internal.callback.CallbackExecutor;
import org.flywaydb.core.internal.callback.CallbackTelemetryModel;
import org.flywaydb.core.internal.callback.SimpleContext;
import org.flywaydb.core.internal.database.base.Connection;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.jdbc.ExecutionTemplateFactory;

public class DefaultCallbackExecutor<E extends CallbackEvent<E>>
implements CallbackExecutor<E> {
    private final Configuration configuration;
    private final Database database;
    private final Schema schema;
    private final FlywayTelemetryManager flywayTelemetryManager;
    private final List<GenericCallback<E>> callbacks;
    private MigrationInfo migrationInfo;

    public DefaultCallbackExecutor(Configuration configuration, Database database, Schema schema, FlywayTelemetryManager flywayTelemetryManager, Collection<GenericCallback<E>> callbacks) {
        this.configuration = configuration;
        this.database = database;
        this.schema = schema;
        this.flywayTelemetryManager = flywayTelemetryManager;
        this.callbacks = new ArrayList<GenericCallback<GenericCallback<E>>>(callbacks);
        this.callbacks.sort(Comparator.comparing(GenericCallback::getCallbackName));
    }

    @Override
    public Collection<String> onEvent(E event) {
        return this.execute(event, (Connection)this.database.getMainConnection());
    }

    @Override
    public void onMigrateOrUndoEvent(E event) {
        SimpleContext context = new SimpleContext(this.configuration, null, this.migrationInfo, null);
        if (this.callbacks.stream().anyMatch(callback -> callback.supports(event, context))) {
            this.execute(event, (Connection)this.database.getEventConnection());
            this.database.disposeEventConnection();
        }
    }

    @Override
    public void setMigrationInfo(MigrationInfo migrationInfo) {
        this.migrationInfo = migrationInfo;
    }

    @Override
    public void onEachMigrateOrUndoEvent(E event) {
        SimpleContext context = new SimpleContext(this.configuration, (Connection)this.database.getMigrationConnection(), this.migrationInfo, null);
        for (GenericCallback<E> callback : this.callbacks) {
            if (!callback.supports(event, context)) continue;
            this.handleEvent(callback, event, context);
        }
    }

    @Override
    public void onEachMigrateOrUndoStatementEvent(E event, String sql, List<Warning> warnings, List<Error> errors) {
        SimpleContext context = new SimpleContext(this.configuration, (Connection)this.database.getMigrationConnection(), this.migrationInfo, sql, warnings, errors);
        for (GenericCallback<E> callback : this.callbacks) {
            if (!callback.supports(event, context)) continue;
            this.handleEvent(callback, event, context);
        }
    }

    @Override
    public void onOperationFinishEvent(E event, OperationResult operationResult) {
        SimpleContext context = new SimpleContext(this.configuration, (Connection)this.database.getMigrationConnection(), this.migrationInfo, operationResult);
        for (GenericCallback<E> callback : this.callbacks) {
            if (!callback.supports(event, context)) continue;
            this.handleEvent(callback, event, context);
        }
    }

    private Collection<String> execute(E event, Connection connection) {
        SimpleContext context = new SimpleContext(this.configuration, connection, null, null);
        List<GenericCallback> callbacksToExecute = this.callbacks.stream().filter(x -> x.supports(event, context)).toList();
        callbacksToExecute.forEach(callback -> {
            if (callback.canHandleInTransaction(event, context)) {
                ExecutionTemplateFactory.createExecutionTemplate(connection.getJdbcConnection(), this.database).execute(() -> {
                    this.execute(connection, (GenericCallback<? super E>)callback, event, context);
                    return null;
                });
            } else {
                this.execute(connection, (GenericCallback<? super E>)callback, event, context);
            }
        });
        return callbacksToExecute.stream().map(GenericCallback::getCallbackName).toList();
    }

    private void execute(Connection connection, GenericCallback<? super E> callback, E event, Context context) {
        connection.restoreOriginalState();
        connection.changeCurrentSchemaTo(this.schema);
        this.handleEvent(callback, event, context);
    }

    private void handleEvent(GenericCallback<? super E> callback, E event, Context context) {
        String callbackType = Optional.ofNullable(callback.getClass().getCanonicalName()).map(x -> x.startsWith("org.flywaydb")).orElse(false) != false ? callback.getClass().getSimpleName() : "(custom callback class)";
        try (CallbackTelemetryModel ignored = new CallbackTelemetryModel(event.getId(), callbackType, this.flywayTelemetryManager);){
            callback.handle(event, context);
        }
        catch (FlywayBlockStatementExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FlywayException("Error while executing " + event.getId() + " callback: " + e.getMessage(), e);
        }
    }
}

