/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap.ppolicy;

import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import org.springframework.core.log.LogMessage;
import org.springframework.ldap.support.LdapUtils;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;
import org.springframework.security.ldap.ppolicy.PasswordPolicyControl;
import org.springframework.security.ldap.ppolicy.PasswordPolicyControlExtractor;
import org.springframework.security.ldap.ppolicy.PasswordPolicyControlFactory;
import org.springframework.security.ldap.ppolicy.PasswordPolicyException;
import org.springframework.security.ldap.ppolicy.PasswordPolicyResponseControl;

public class PasswordPolicyAwareContextSource
extends DefaultSpringSecurityContextSource {
    public PasswordPolicyAwareContextSource(String providerUrl) {
        super(providerUrl);
    }

    public DirContext getContext(String principal, String credentials) throws PasswordPolicyException {
        if (principal.equals(this.getUserDn())) {
            return super.getContext(principal, credentials);
        }
        this.logger.trace((Object)LogMessage.format((String)"Binding as %s, prior to reconnect as user %s", (Object)this.getUserDn(), (Object)principal));
        LdapContext ctx = (LdapContext)super.getContext(this.getUserDn(), this.getPassword());
        Control[] rctls = new Control[]{new PasswordPolicyControl(false)};
        try {
            ctx.addToEnvironment("java.naming.security.principal", principal);
            ctx.addToEnvironment("java.naming.security.credentials", credentials);
            ctx.reconnect(rctls);
        }
        catch (NamingException ex) {
            PasswordPolicyResponseControl ctrl = PasswordPolicyControlExtractor.extractControl(ctx);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)LogMessage.format((String)"Failed to bind with %s", (Object)ctrl), (Throwable)ex);
            }
            LdapUtils.closeContext((DirContext)ctx);
            if (ctrl != null && ctrl.isLocked()) {
                throw new PasswordPolicyException(ctrl.getErrorStatus());
            }
            throw LdapUtils.convertLdapException((NamingException)ex);
        }
        this.logger.debug((Object)LogMessage.of(() -> "Bound with " + String.valueOf(PasswordPolicyControlExtractor.extractControl(ctx))));
        return ctx;
    }

    protected Hashtable getAuthenticatedEnv(String principal, String credentials) {
        Hashtable env = super.getAuthenticatedEnv(principal, credentials);
        env.put("java.naming.factory.control", PasswordPolicyControlFactory.class.getName());
        return env;
    }
}

