---
layout: news_item
title: "ORC 2.0.1 Released"
date: "2024-05-14 00:00:00 0000"
author: william
version: 2.0.1
categories: [release]
---

The ORC team is excited to announce the release of ORC v2.0.1.

{% assign releaseName = "2.0.1" %}
{% include release_description.md %}

The improvements (tools):
- [ORC-1644]({{site.jira}}/ORC-1644) Add merge tool to merge multiple ORC files into a single ORC file
- [ORC-1647]({{site.jira}}/ORC-1647) Tips for supporting ORC in the convert command
- [ORC-1667]({{site.jira}}/ORC-1667) Add check tool to check the index of the specified column

The bug fixes:
- [ORC-1646]({{site.jira}}/ORC-1646) Close the reader when reading the schema with the convert command 
- [ORC-1654]({{site.jira}}/ORC-1654) [C++] Count up EvaluatedRowGroupCount correctly 
- [ORC-1684]({{site.jira}}/ORC-1684) [C++] Find tzdb without TZDIR when in conda-environments 
- [ORC-1688]({{site.jira}}/ORC-1688) [C++] Do not access TZDB if there is no timestamp type
- [ORC-1696]({{site.jira}}/ORC-1696) Fix ClassCastException when reading avro decimal type in bechmark 
The tasks:
- [ORC-1649]({{site.jira}}/ORC-1649) [C++][Conan] Add 2.0.0 to conan recipe and update release guide
- [ORC-1669]({{site.jira}}/ORC-1669) [C++] Deprecate HDFS support
- [ORC-1686]({{site.jira}}/ORC-1686) [C++] Avoid using std::filesystem

The test changes:
- [ORC-1648]({{site.jira}}/ORC-1648) Add test to convert ORC in the convert command 
- [ORC-1663]({{site.jira}}/ORC-1663) [C++] Enable TestTimezone.testMissingTZDB on Windows
- [ORC-1672]({{site.jira}}/ORC-1672) Remove test packages o.a.o.tools.check
- [ORC-1673]({{site.jira}}/ORC-1673) Remove test packages `o.a.o.tools.[count|merge|sizes]`
- [ORC-1676]({{site.jira}}/ORC-1676) Use Hive 4.0.0 in benchmark
- [ORC-1681]({{site.jira}}/ORC-1681) Remove redundant import statement in tests to fix checkstyle failures
- [ORC-1699]({{site.jira}}/ORC-1699) Fix SparkBenchmark in Parquet format according to SPARK-40918
- [ORC-1704]({{site.jira}}/ORC-1704) Migration to Scala 2.13 of Apache Spark 3.5.1 at SparkBenchmark
- [ORC-1707]({{site.jira}}/ORC-1707) Fix sun.util.calendar IllegalAccessException when SparkBenchmark runs on JDK17 
- [ORC-1708]({{site.jira}}/ORC-1708) Support data/compress options in Hive benchmark

The build and dependency changes:
- [ORC-1670]({{site.jira}}/ORC-1670) Upgrade zstd-jni to 1.5.6-1
- [ORC-1679]({{site.jira}}/ORC-1679) Bump zstd-jni to 1.5.6-2
- [ORC-1695]({{site.jira}}/ORC-1695) Upgrade gson to 2.10.1
- [ORC-1698]({{site.jira}}/ORC-1698) Upgrade commons-cli to 1.7.0
- [ORC-1705]({{site.jira}}/ORC-1705) Upgrade zstd-jni to 1.5.6-3
- [ORC-1714]({{site.jira}}/ORC-1714) Bump commons-csv to 1.11.0
- [ORC-1715]({{site.jira}}/ORC-1715) Bump org.objenesis:objenesis to 3.3

The documentation changes:
- [ORC-1668]({{site.jira}}/ORC-1668) Add merge command to Java tools documentation
