/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.server;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.discovery.client.ServiceDescriptor;
import io.airlift.discovery.client.ServiceInventory;
import io.airlift.discovery.client.ServiceSelector;
import io.airlift.node.NodeInfo;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class DiscoveryServiceSelector
implements ServiceSelector {
    private final NodeInfo nodeInfo;
    private final ServiceInventory inventory;

    @Inject
    public DiscoveryServiceSelector(NodeInfo nodeInfo, ServiceInventory inventory) {
        this.nodeInfo = Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        this.inventory = Objects.requireNonNull(inventory, "inventory is null");
    }

    public String getType() {
        return "discovery";
    }

    public String getPool() {
        return this.nodeInfo.getPool();
    }

    public List<ServiceDescriptor> selectAllServices() {
        return ImmutableList.copyOf((Iterable)this.inventory.getServiceDescriptors(this.getType()));
    }

    public ListenableFuture<List<ServiceDescriptor>> refresh() {
        this.inventory.updateServiceInventory();
        return Futures.immediateFuture(this.selectAllServices());
    }
}

