/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.DropTable;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class DropTableTask
implements DataDefinitionTask<DropTable> {
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public DropTableTask(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    @Override
    public String getName() {
        return "DROP TABLE";
    }

    @Override
    public ListenableFuture<Void> execute(DropTable statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        QualifiedObjectName tableName;
        Session session = stateMachine.getSession();
        if (this.metadata.isMaterializedView(session, tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getTableName()))) {
            if (!statement.isExists()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table '%s' does not exist, but a materialized view with that name exists. Did you mean DROP MATERIALIZED VIEW %s?", tableName, tableName);
            }
            return Futures.immediateVoidFuture();
        }
        if (this.metadata.isView(session, tableName)) {
            if (!statement.isExists()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table '%s' does not exist, but a view with that name exists. Did you mean DROP VIEW %s?", tableName, tableName);
            }
            return Futures.immediateVoidFuture();
        }
        Optional<TableHandle> tableHandle = this.metadata.getTableHandle(session, tableName);
        if (tableHandle.isEmpty()) {
            if (!statement.isExists()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table '%s' does not exist", tableName);
            }
            return Futures.immediateVoidFuture();
        }
        this.accessControl.checkCanDropTable(session.toSecurityContext(), tableName);
        this.metadata.dropTable(session, tableHandle.get());
        return Futures.immediateVoidFuture();
    }
}

