/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.metadata.AggregationFunctionMetadata;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.FunctionNullability;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlAggregationFunction;
import io.trino.operator.aggregation.AggregationMetadata;
import io.trino.operator.aggregation.state.LongDecimalWithOverflowAndLongState;
import io.trino.operator.aggregation.state.LongDecimalWithOverflowAndLongStateFactory;
import io.trino.operator.aggregation.state.LongDecimalWithOverflowAndLongStateSerializer;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.Int128;
import io.trino.spi.type.Int128Math;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarbinaryType;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;

public class DecimalAverageAggregation
extends SqlAggregationFunction {
    public static final DecimalAverageAggregation DECIMAL_AVERAGE_AGGREGATION = new DecimalAverageAggregation();
    private static final String NAME = "avg";
    private static final MethodHandle SHORT_DECIMAL_INPUT_FUNCTION = Reflection.methodHandle(DecimalAverageAggregation.class, "inputShortDecimal", LongDecimalWithOverflowAndLongState.class, Block.class, Integer.TYPE);
    private static final MethodHandle LONG_DECIMAL_INPUT_FUNCTION = Reflection.methodHandle(DecimalAverageAggregation.class, "inputLongDecimal", LongDecimalWithOverflowAndLongState.class, Block.class, Integer.TYPE);
    private static final MethodHandle SHORT_DECIMAL_OUTPUT_FUNCTION = Reflection.methodHandle(DecimalAverageAggregation.class, "outputShortDecimal", DecimalType.class, LongDecimalWithOverflowAndLongState.class, BlockBuilder.class);
    private static final MethodHandle LONG_DECIMAL_OUTPUT_FUNCTION = Reflection.methodHandle(DecimalAverageAggregation.class, "outputLongDecimal", DecimalType.class, LongDecimalWithOverflowAndLongState.class, BlockBuilder.class);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(DecimalAverageAggregation.class, "combine", LongDecimalWithOverflowAndLongState.class, LongDecimalWithOverflowAndLongState.class);
    private static final BigInteger TWO = new BigInteger("2");
    private static final BigInteger OVERFLOW_MULTIPLIER = TWO.pow(128);

    public DecimalAverageAggregation() {
        super(new FunctionMetadata(new Signature(NAME, new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"p"), TypeSignatureParameter.typeVariable((String)"s")}), (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"p"), TypeSignatureParameter.typeVariable((String)"s")}))), new FunctionNullability(true, (List<Boolean>)ImmutableList.of((Object)false)), false, true, "Calculates the average value", FunctionKind.AGGREGATE), new AggregationFunctionMetadata(false, VarbinaryType.VARBINARY.getTypeSignature()));
    }

    @Override
    public AggregationMetadata specialize(BoundSignature boundSignature) {
        MethodHandle outputFunction;
        MethodHandle inputFunction;
        Type type = (Type)Iterables.getOnlyElement(boundSignature.getArgumentTypes());
        Preconditions.checkArgument((boolean)(type instanceof DecimalType), (Object)"type must be Decimal");
        Class<LongDecimalWithOverflowAndLongState> stateInterface = LongDecimalWithOverflowAndLongState.class;
        LongDecimalWithOverflowAndLongStateSerializer stateSerializer = new LongDecimalWithOverflowAndLongStateSerializer();
        if (((DecimalType)type).isShort()) {
            inputFunction = SHORT_DECIMAL_INPUT_FUNCTION;
            outputFunction = SHORT_DECIMAL_OUTPUT_FUNCTION;
        } else {
            inputFunction = LONG_DECIMAL_INPUT_FUNCTION;
            outputFunction = LONG_DECIMAL_OUTPUT_FUNCTION;
        }
        outputFunction = outputFunction.bindTo(type);
        return new AggregationMetadata(inputFunction, Optional.empty(), Optional.of(COMBINE_FUNCTION), outputFunction, (List<AggregationMetadata.AccumulatorStateDescriptor<?>>)ImmutableList.of(new AggregationMetadata.AccumulatorStateDescriptor<LongDecimalWithOverflowAndLongState>(stateInterface, stateSerializer, new LongDecimalWithOverflowAndLongStateFactory())));
    }

    public static void inputShortDecimal(LongDecimalWithOverflowAndLongState state, Block block, int position) {
        state.addLong(1L);
        state.setNotNull();
        long[] decimal = state.getDecimalArray();
        int offset = state.getDecimalArrayOffset();
        long rightLow = block.getLong(position, 0);
        long rightHigh = rightLow >> 63;
        long overflow = Int128Math.addWithOverflow((long)decimal[offset], (long)decimal[offset + 1], (long)rightHigh, (long)rightLow, (long[])decimal, (int)offset);
        state.addOverflow(overflow);
    }

    public static void inputLongDecimal(LongDecimalWithOverflowAndLongState state, Block block, int position) {
        state.addLong(1L);
        state.setNotNull();
        long[] decimal = state.getDecimalArray();
        int offset = state.getDecimalArrayOffset();
        long rightHigh = block.getLong(position, 0);
        long rightLow = block.getLong(position, 8);
        long overflow = Int128Math.addWithOverflow((long)decimal[offset], (long)decimal[offset + 1], (long)rightHigh, (long)rightLow, (long[])decimal, (int)offset);
        state.addOverflow(overflow);
    }

    public static void combine(LongDecimalWithOverflowAndLongState state, LongDecimalWithOverflowAndLongState otherState) {
        state.addLong(otherState.getLong());
        long[] decimal = state.getDecimalArray();
        int offset = state.getDecimalArrayOffset();
        long[] otherDecimal = otherState.getDecimalArray();
        int otherOffset = otherState.getDecimalArrayOffset();
        if (state.isNotNull()) {
            long overflow = Int128Math.addWithOverflow((long)decimal[offset], (long)decimal[offset + 1], (long)otherDecimal[otherOffset], (long)otherDecimal[otherOffset + 1], (long[])decimal, (int)offset);
            state.addOverflow(overflow + otherState.getOverflow());
        } else {
            state.setNotNull();
            decimal[offset] = otherDecimal[otherOffset];
            decimal[offset + 1] = otherDecimal[otherOffset + 1];
            state.setOverflow(otherState.getOverflow());
        }
    }

    public static void outputShortDecimal(DecimalType type, LongDecimalWithOverflowAndLongState state, BlockBuilder out) {
        if (state.getLong() == 0L) {
            out.appendNull();
        } else {
            Decimals.writeShortDecimal((BlockBuilder)out, (long)DecimalAverageAggregation.average(state, type).toLongExact());
        }
    }

    public static void outputLongDecimal(DecimalType type, LongDecimalWithOverflowAndLongState state, BlockBuilder out) {
        if (state.getLong() == 0L) {
            out.appendNull();
        } else {
            type.writeObject(out, (Object)DecimalAverageAggregation.average(state, type));
        }
    }

    @VisibleForTesting
    public static Int128 average(LongDecimalWithOverflowAndLongState state, DecimalType type) {
        long[] decimal = state.getDecimalArray();
        int offset = state.getDecimalArrayOffset();
        long overflow = state.getOverflow();
        if (overflow != 0L) {
            BigDecimal sum = new BigDecimal(Int128.valueOf((long)decimal[offset], (long)decimal[offset + 1]).toBigInteger(), type.getScale());
            sum = sum.add(new BigDecimal(OVERFLOW_MULTIPLIER.multiply(BigInteger.valueOf(overflow))));
            BigDecimal count = BigDecimal.valueOf(state.getLong());
            return Decimals.encodeScaledValue((BigDecimal)sum.divide(count, type.getScale(), 4), (int)type.getScale());
        }
        Int128 result = Int128Math.divideRoundUp((long)decimal[offset], (long)decimal[offset + 1], (int)0, (long)0L, (long)state.getLong(), (int)0);
        if (Decimals.overflows((Int128)result)) {
            throw new ArithmeticException("Decimal overflow");
        }
        return result;
    }
}

