/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.arrayagg;

import io.trino.operator.aggregation.arrayagg.ArrayAggregationState;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;

public class ArrayAggregationStateSerializer
implements AccumulatorStateSerializer<ArrayAggregationState> {
    private final Type elementType;
    private final Type arrayType;

    public ArrayAggregationStateSerializer(Type elementType) {
        this.elementType = elementType;
        this.arrayType = new ArrayType(elementType);
    }

    public Type getSerializedType() {
        return this.arrayType;
    }

    public void serialize(ArrayAggregationState state, BlockBuilder out) {
        if (state.isEmpty()) {
            out.appendNull();
        } else {
            BlockBuilder entryBuilder = out.beginBlockEntry();
            state.forEach((block, position) -> this.elementType.appendTo(block, position, entryBuilder));
            out.closeEntry();
        }
    }

    public void deserialize(Block block, int index, ArrayAggregationState state) {
        state.reset();
        Block stateBlock = (Block)this.arrayType.getObject(block, index);
        for (int i = 0; i < stateBlock.getPositionCount(); ++i) {
            state.add(stateBlock, i);
        }
    }
}

