/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.annotations;

import io.trino.metadata.FunctionBinding;
import io.trino.metadata.FunctionDependencies;
import io.trino.metadata.FunctionDependencyDeclaration;
import io.trino.metadata.FunctionInvoker;
import io.trino.metadata.SignatureBinder;
import io.trino.operator.annotations.ScalarImplementationDependency;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.TypeSignature;
import java.util.Objects;

public final class CastImplementationDependency
extends ScalarImplementationDependency {
    private final TypeSignature fromType;
    private final TypeSignature toType;

    public CastImplementationDependency(TypeSignature fromType, TypeSignature toType, InvocationConvention invocationConvention, Class<?> type) {
        super(invocationConvention, type);
        this.fromType = Objects.requireNonNull(fromType, "fromType is null");
        this.toType = Objects.requireNonNull(toType, "toType is null");
    }

    public TypeSignature getFromType() {
        return this.fromType;
    }

    public TypeSignature getToType() {
        return this.toType;
    }

    @Override
    public void declareDependencies(FunctionDependencyDeclaration.FunctionDependencyDeclarationBuilder builder) {
        builder.addCastSignature(this.fromType, this.toType);
    }

    @Override
    protected FunctionInvoker getInvoker(FunctionBinding functionBinding, FunctionDependencies functionDependencies, InvocationConvention invocationConvention) {
        TypeSignature from = SignatureBinder.applyBoundVariables(this.fromType, functionBinding);
        TypeSignature to = SignatureBinder.applyBoundVariables(this.toType, functionBinding);
        return functionDependencies.getCastSignatureInvoker(from, to, invocationConvention);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CastImplementationDependency that = (CastImplementationDependency)o;
        return Objects.equals(this.fromType, that.fromType) && Objects.equals(this.toType, that.toType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fromType, this.toType);
    }
}

