/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.execution.scheduler.BucketNodeMap;
import io.trino.execution.scheduler.FixedBucketNodeMap;
import io.trino.execution.scheduler.NodeScheduler;
import io.trino.execution.scheduler.group.DynamicBucketNodeMap;
import io.trino.metadata.InternalNode;
import io.trino.metadata.Split;
import io.trino.operator.BucketPartitionFunction;
import io.trino.operator.PartitionFunction;
import io.trino.spi.connector.BucketFunction;
import io.trino.spi.connector.ConnectorBucketNodeMap;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPartitionHandle;
import io.trino.spi.type.Type;
import io.trino.split.EmptySplit;
import io.trino.sql.planner.NodePartitionMap;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.type.BlockTypeOperators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.ToIntFunction;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.inject.Inject;

public class NodePartitioningManager {
    private final NodeScheduler nodeScheduler;
    private final BlockTypeOperators blockTypeOperators;
    private final ConcurrentMap<CatalogName, ConnectorNodePartitioningProvider> partitioningProviders = new ConcurrentHashMap<CatalogName, ConnectorNodePartitioningProvider>();

    @Inject
    public NodePartitioningManager(NodeScheduler nodeScheduler, BlockTypeOperators blockTypeOperators) {
        this.nodeScheduler = Objects.requireNonNull(nodeScheduler, "nodeScheduler is null");
        this.blockTypeOperators = Objects.requireNonNull(blockTypeOperators, "blockTypeOperators is null");
    }

    public void addPartitioningProvider(CatalogName catalogName, ConnectorNodePartitioningProvider nodePartitioningProvider) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(nodePartitioningProvider, "nodePartitioningProvider is null");
        Preconditions.checkArgument((this.partitioningProviders.putIfAbsent(catalogName, nodePartitioningProvider) == null ? 1 : 0) != 0, (String)"NodePartitioningProvider for connector '%s' is already registered", (Object)catalogName);
    }

    public void removePartitioningProvider(CatalogName catalogName) {
        this.partitioningProviders.remove(catalogName);
    }

    public PartitionFunction getPartitionFunction(Session session, PartitioningScheme partitioningScheme, List<Type> partitionChannelTypes) {
        int[] bucketToPartition = partitioningScheme.getBucketToPartition().orElseThrow(() -> new IllegalArgumentException("Bucket to partition must be set before a partition function can be created"));
        PartitioningHandle partitioningHandle = partitioningScheme.getPartitioning().getHandle();
        if (partitioningHandle.getConnectorHandle() instanceof SystemPartitioningHandle) {
            return ((SystemPartitioningHandle)partitioningHandle.getConnectorHandle()).getPartitionFunction(partitionChannelTypes, partitioningScheme.getHashColumn().isPresent(), bucketToPartition, this.blockTypeOperators);
        }
        BucketFunction bucketFunction = this.getBucketFunction(session, partitioningHandle, partitionChannelTypes, bucketToPartition.length);
        return new BucketPartitionFunction(bucketFunction, bucketToPartition);
    }

    public BucketFunction getBucketFunction(Session session, PartitioningHandle partitioningHandle, List<Type> partitionChannelTypes, int bucketCount) {
        CatalogName catalogName = partitioningHandle.getConnectorId().orElseThrow(() -> new IllegalArgumentException("No connector ID for partitioning handle: " + partitioningHandle));
        ConnectorNodePartitioningProvider partitioningProvider = this.getPartitioningProvider(catalogName);
        BucketFunction bucketFunction = partitioningProvider.getBucketFunction(partitioningHandle.getTransactionHandle().orElseThrow(() -> new IllegalArgumentException("No transactionHandle for partitioning handle: " + partitioningHandle)), session.toConnectorSession(), partitioningHandle.getConnectorHandle(), partitionChannelTypes, bucketCount);
        Preconditions.checkArgument((bucketFunction != null ? 1 : 0) != 0, (String)"No bucket function for partitioning: %s", (Object)partitioningHandle);
        return bucketFunction;
    }

    public List<ConnectorPartitionHandle> listPartitionHandles(Session session, PartitioningHandle partitioningHandle) {
        CatalogName catalogName = partitioningHandle.getConnectorId().orElseThrow(() -> new IllegalArgumentException("No connector ID for partitioning handle: " + partitioningHandle));
        ConnectorNodePartitioningProvider partitioningProvider = this.getPartitioningProvider(catalogName);
        return partitioningProvider.listPartitionHandles(partitioningHandle.getTransactionHandle().orElseThrow(() -> new IllegalArgumentException("No transactionHandle for partitioning handle: " + partitioningHandle)), session.toConnectorSession(catalogName), partitioningHandle.getConnectorHandle());
    }

    public NodePartitionMap getNodePartitioningMap(Session session, PartitioningHandle partitioningHandle) {
        List<InternalNode> bucketToNode;
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(partitioningHandle, "partitioningHandle is null");
        if (partitioningHandle.getConnectorHandle() instanceof SystemPartitioningHandle) {
            return ((SystemPartitioningHandle)partitioningHandle.getConnectorHandle()).getNodePartitionMap(session, this.nodeScheduler);
        }
        ConnectorBucketNodeMap connectorBucketNodeMap = this.getConnectorBucketNodeMap(session, partitioningHandle);
        Preconditions.checkArgument((connectorBucketNodeMap.getBucketCount() < 1000000 ? 1 : 0) != 0, (String)"Too many buckets in partitioning: %s", (int)connectorBucketNodeMap.getBucketCount());
        if (connectorBucketNodeMap.hasFixedMapping()) {
            bucketToNode = NodePartitioningManager.getFixedMapping(connectorBucketNodeMap);
        } else {
            CatalogName catalogName = partitioningHandle.getConnectorId().orElseThrow(() -> new IllegalArgumentException("No connector ID for partitioning handle: " + partitioningHandle));
            bucketToNode = NodePartitioningManager.createArbitraryBucketToNode(this.nodeScheduler.createNodeSelector(session, Optional.of(catalogName)).allNodes(), connectorBucketNodeMap.getBucketCount());
        }
        int[] bucketToPartition = new int[connectorBucketNodeMap.getBucketCount()];
        HashBiMap nodeToPartition = HashBiMap.create();
        int nextPartitionId = 0;
        for (int bucket = 0; bucket < bucketToNode.size(); ++bucket) {
            InternalNode node = bucketToNode.get(bucket);
            Integer partitionId = (Integer)nodeToPartition.get((Object)node);
            if (partitionId == null) {
                partitionId = nextPartitionId++;
                nodeToPartition.put((Object)node, (Object)partitionId);
            }
            bucketToPartition[bucket] = partitionId;
        }
        List partitionToNode = (List)IntStream.range(0, nodeToPartition.size()).mapToObj(arg_0 -> NodePartitioningManager.lambda$getNodePartitioningMap$6((BiMap)nodeToPartition, arg_0)).collect(ImmutableList.toImmutableList());
        return new NodePartitionMap(partitionToNode, bucketToPartition, this.getSplitToBucket(session, partitioningHandle));
    }

    public BucketNodeMap getBucketNodeMap(Session session, PartitioningHandle partitioningHandle, boolean preferDynamic) {
        ConnectorBucketNodeMap connectorBucketNodeMap = this.getConnectorBucketNodeMap(session, partitioningHandle);
        if (connectorBucketNodeMap.hasFixedMapping()) {
            return new FixedBucketNodeMap(this.getSplitToBucket(session, partitioningHandle), NodePartitioningManager.getFixedMapping(connectorBucketNodeMap));
        }
        if (preferDynamic) {
            return new DynamicBucketNodeMap(this.getSplitToBucket(session, partitioningHandle), connectorBucketNodeMap.getBucketCount());
        }
        Optional<CatalogName> catalogName = partitioningHandle.getConnectorId();
        Preconditions.checkArgument((boolean)catalogName.isPresent(), (String)"No connector ID for partitioning handle: %s", (Object)partitioningHandle);
        return new FixedBucketNodeMap(this.getSplitToBucket(session, partitioningHandle), NodePartitioningManager.createArbitraryBucketToNode(new ArrayList<InternalNode>(this.nodeScheduler.createNodeSelector(session, catalogName).allNodes()), connectorBucketNodeMap.getBucketCount()));
    }

    private static List<InternalNode> getFixedMapping(ConnectorBucketNodeMap connectorBucketNodeMap) {
        return (List)connectorBucketNodeMap.getFixedMapping().stream().map(InternalNode.class::cast).collect(ImmutableList.toImmutableList());
    }

    public ConnectorBucketNodeMap getConnectorBucketNodeMap(Session session, PartitioningHandle partitioningHandle) {
        CatalogName catalogName = partitioningHandle.getConnectorId().orElseThrow(() -> new IllegalArgumentException("No connector ID for partitioning handle: " + partitioningHandle));
        ConnectorNodePartitioningProvider partitioningProvider = this.getPartitioningProvider(catalogName);
        ConnectorBucketNodeMap connectorBucketNodeMap = partitioningProvider.getBucketNodeMap(partitioningHandle.getTransactionHandle().orElseThrow(() -> new IllegalArgumentException("No transactionHandle for partitioning handle: " + partitioningHandle)), session.toConnectorSession(catalogName), partitioningHandle.getConnectorHandle());
        Preconditions.checkArgument((connectorBucketNodeMap != null ? 1 : 0) != 0, (String)"No partition map %s", (Object)partitioningHandle);
        return connectorBucketNodeMap;
    }

    private ToIntFunction<Split> getSplitToBucket(Session session, PartitioningHandle partitioningHandle) {
        CatalogName catalogName = partitioningHandle.getConnectorId().orElseThrow(() -> new IllegalArgumentException("No connector ID for partitioning handle: " + partitioningHandle));
        ConnectorNodePartitioningProvider partitioningProvider = this.getPartitioningProvider(catalogName);
        ToIntFunction splitBucketFunction = partitioningProvider.getSplitBucketFunction(partitioningHandle.getTransactionHandle().orElseThrow(() -> new IllegalArgumentException("No transactionHandle for partitioning handle: " + partitioningHandle)), session.toConnectorSession(catalogName), partitioningHandle.getConnectorHandle());
        Preconditions.checkArgument((splitBucketFunction != null ? 1 : 0) != 0, (String)"No partitioning %s", (Object)partitioningHandle);
        return split -> {
            int bucket = split.getConnectorSplit() instanceof EmptySplit ? (split.getLifespan().isTaskWide() ? 0 : split.getLifespan().getId()) : splitBucketFunction.applyAsInt(split.getConnectorSplit());
            if (!split.getLifespan().isTaskWide()) {
                Preconditions.checkArgument((split.getLifespan().getId() == bucket ? 1 : 0) != 0);
            }
            return bucket;
        };
    }

    private ConnectorNodePartitioningProvider getPartitioningProvider(CatalogName catalogName) {
        ConnectorNodePartitioningProvider partitioningProvider = (ConnectorNodePartitioningProvider)this.partitioningProviders.get(Objects.requireNonNull(catalogName, "catalogName is null"));
        Preconditions.checkArgument((partitioningProvider != null ? 1 : 0) != 0, (String)"No partitioning provider for connector %s", (Object)catalogName);
        return partitioningProvider;
    }

    private static List<InternalNode> createArbitraryBucketToNode(List<InternalNode> nodes, int bucketCount) {
        return (List)NodePartitioningManager.cyclingShuffledStream(nodes).limit(bucketCount).collect(ImmutableList.toImmutableList());
    }

    private static <T> Stream<T> cyclingShuffledStream(Collection<T> collection) {
        ArrayList list = new ArrayList(collection);
        Collections.shuffle(list);
        return Stream.generate(() -> list).flatMap(Collection::stream);
    }

    private static /* synthetic */ InternalNode lambda$getNodePartitioningMap$6(BiMap nodeToPartition, int partitionId) {
        return (InternalNode)nodeToPartition.inverse().get((Object)partitionId);
    }
}

