/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.optimizations.QueryCardinalityUtil;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Optional;

public class PushLimitThroughOuterJoin
implements Rule<LimitNode> {
    private static final Capture<JoinNode> CHILD = Capture.newCapture();
    private static final Pattern<LimitNode> PATTERN = Patterns.limit().matching(limit -> !limit.isWithTies()).with(Patterns.source().matching(Patterns.join().with(Patterns.Join.type().matching(type -> type == JoinNode.Type.LEFT || type == JoinNode.Type.RIGHT)).capturedAs(CHILD)));

    @Override
    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LimitNode parent, Captures captures, Rule.Context context) {
        JoinNode joinNode = (JoinNode)captures.get(CHILD);
        PlanNode left = joinNode.getLeft();
        PlanNode right = joinNode.getRight();
        if (joinNode.getType() == JoinNode.Type.LEFT && !QueryCardinalityUtil.isAtMost(left, context.getLookup(), parent.getCount())) {
            if (!ImmutableSet.copyOf(left.getOutputSymbols()).containsAll(parent.getPreSortedInputs())) {
                return Rule.Result.empty();
            }
            return Rule.Result.ofPlanNode(parent.replaceChildren((List<PlanNode>)ImmutableList.of((Object)joinNode.replaceChildren((List<PlanNode>)ImmutableList.of((Object)new LimitNode(context.getIdAllocator().getNextId(), left, parent.getCount(), Optional.empty(), true, parent.getPreSortedInputs()), (Object)right)))));
        }
        if (joinNode.getType() == JoinNode.Type.RIGHT && !QueryCardinalityUtil.isAtMost(right, context.getLookup(), parent.getCount())) {
            if (!ImmutableSet.copyOf(right.getOutputSymbols()).containsAll(parent.getPreSortedInputs())) {
                return Rule.Result.empty();
            }
            return Rule.Result.ofPlanNode(parent.replaceChildren((List<PlanNode>)ImmutableList.of((Object)joinNode.replaceChildren((List<PlanNode>)ImmutableList.of((Object)left, (Object)new LimitNode(context.getIdAllocator().getNextId(), right, parent.getCount(), Optional.empty(), true, parent.getPreSortedInputs()))))));
        }
        return Rule.Result.empty();
    }
}

