/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.rowpattern.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

public class IrQuantifier {
    private final int atLeast;
    private final Optional<Integer> atMost;
    private final boolean greedy;

    public static IrQuantifier zeroOrMore(boolean greedy) {
        return new IrQuantifier(0, Optional.empty(), greedy);
    }

    public static IrQuantifier oneOrMore(boolean greedy) {
        return new IrQuantifier(1, Optional.empty(), greedy);
    }

    public static IrQuantifier zeroOrOne(boolean greedy) {
        return new IrQuantifier(0, Optional.of(1), greedy);
    }

    public static IrQuantifier range(Optional<Integer> atLeast, Optional<Integer> atMost, boolean greedy) {
        return new IrQuantifier(atLeast.orElse(0), atMost, greedy);
    }

    @JsonCreator
    public IrQuantifier(int atLeast, Optional<Integer> atMost, boolean greedy) {
        this.atLeast = atLeast;
        this.atMost = Objects.requireNonNull(atMost, "atMost is null");
        this.greedy = greedy;
    }

    @JsonProperty
    public int getAtLeast() {
        return this.atLeast;
    }

    @JsonProperty
    public Optional<Integer> getAtMost() {
        return this.atMost;
    }

    @JsonProperty
    public boolean isGreedy() {
        return this.greedy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IrQuantifier o = (IrQuantifier)obj;
        return this.atLeast == o.atLeast && Objects.equals(this.atMost, o.atMost) && this.greedy == o.greedy;
    }

    public int hashCode() {
        return Objects.hash(this.atLeast, this.atMost, this.greedy);
    }

    public String toString() {
        return String.format("{%s, %s}", this.atLeast, this.atMost.map(Object::toString).orElse("\u221e"));
    }
}

