/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.BigintType;
import io.trino.testing.TestingConnectorSession;
import io.trino.testing.TestingMetadata;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestTestingMetadata {
    @Test
    public void testRenameMaterializedView() {
        this.testRenameMaterializedView("1initial", "2newName");
        this.testRenameMaterializedView("2initial", "1newName");
    }

    private void testRenameMaterializedView(String source, String target) {
        SchemaTableName initialName = SchemaTableName.schemaTableName((String)"schema", (String)source);
        SchemaTableName newName = SchemaTableName.schemaTableName((String)"schema", (String)target);
        TestingMetadata metadata = new TestingMetadata();
        ConnectorMaterializedViewDefinition viewDefinition = TestTestingMetadata.someMaterializedView();
        metadata.createMaterializedView(TestingConnectorSession.SESSION, initialName, viewDefinition, false, false);
        metadata.renameMaterializedView(TestingConnectorSession.SESSION, initialName, newName);
        Assertions.assertThat(metadata.getMaterializedView(TestingConnectorSession.SESSION, initialName)).isEmpty();
        Assertions.assertThat(metadata.getMaterializedView(TestingConnectorSession.SESSION, newName)).hasValue((Object)viewDefinition);
    }

    private static ConnectorMaterializedViewDefinition someMaterializedView() {
        return new ConnectorMaterializedViewDefinition("select 1", Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new ConnectorMaterializedViewDefinition.Column("test", BigintType.BIGINT.getTypeId())), Optional.empty(), Optional.of("owner"), (Map)ImmutableMap.of());
    }
}

