/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import io.netty.util.Recycler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.ManagedCursorImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OpReadEntry
implements AsyncCallbacks.ReadEntriesCallback {
    static final OpReadEntry WAITING_READ_OP_FOR_CLOSED_CURSOR = new OpReadEntry();
    private static final AtomicInteger opReadIdGenerator = new AtomicInteger(1);
    int id;
    ManagedCursorImpl cursor;
    PositionImpl readPosition;
    private int count;
    private AsyncCallbacks.ReadEntriesCallback callback;
    Object ctx;
    private List<Entry> entries;
    private PositionImpl nextReadPosition;
    PositionImpl maxPosition;
    Predicate<PositionImpl> skipCondition;
    boolean skipOpenLedgerFullyAcked = false;
    private final Recycler.Handle<OpReadEntry> recyclerHandle;
    private static final Recycler<OpReadEntry> RECYCLER = new Recycler<OpReadEntry>(){

        protected OpReadEntry newObject(Recycler.Handle<OpReadEntry> recyclerHandle) {
            return new OpReadEntry(recyclerHandle);
        }
    };
    private static final Logger log = LoggerFactory.getLogger(OpReadEntry.class);

    public static OpReadEntry create(ManagedCursorImpl cursor, PositionImpl readPositionRef, int count, AsyncCallbacks.ReadEntriesCallback callback, Object ctx, PositionImpl maxPosition, Predicate<PositionImpl> skipCondition, boolean skipOpenLedgerFullyAcked) {
        OpReadEntry op = (OpReadEntry)RECYCLER.get();
        op.id = opReadIdGenerator.getAndIncrement();
        op.readPosition = cursor.ledger.startReadOperationOnLedger(readPositionRef);
        op.cursor = cursor;
        op.count = count;
        op.callback = callback;
        op.entries = new ArrayList<Entry>();
        if (maxPosition == null) {
            maxPosition = PositionImpl.LATEST;
        }
        op.maxPosition = maxPosition;
        op.skipCondition = skipCondition;
        op.skipOpenLedgerFullyAcked = skipOpenLedgerFullyAcked;
        op.ctx = ctx;
        op.nextReadPosition = PositionImpl.get(op.readPosition);
        return op;
    }

    private void internalReadEntriesComplete(List<Entry> returnedEntries) {
        if (returnedEntries.isEmpty()) {
            log.warn("[{}] Read no entries unexpectedly", (Object)this);
            this.checkReadCompletion();
            return;
        }
        int entriesCount = returnedEntries.size();
        long entriesSize = 0L;
        for (int i = 0; i < entriesCount; ++i) {
            entriesSize += (long)returnedEntries.get(i).getLength();
        }
        this.cursor.updateReadStats(entriesCount, entriesSize);
        if (log.isDebugEnabled()) {
            log.debug("[{}][{}] Read entries succeeded batch_size={} cumulative_size={} requested_count={}", new Object[]{this.cursor.ledger.getName(), this.cursor.getName(), returnedEntries.size(), this.entries.size(), this.count});
        }
        Position lastPosition = returnedEntries.get(entriesCount - 1).getPosition();
        List<Entry> filteredEntries = this.cursor.filterReadEntries(returnedEntries);
        this.entries.addAll(filteredEntries);
        Position nexReadPosition = entriesCount != filteredEntries.size() ? this.cursor.getNextAvailablePosition((PositionImpl)lastPosition) : lastPosition.getNext();
        this.updateReadPosition(nexReadPosition);
        this.checkReadCompletion();
    }

    @Override
    public void readEntriesComplete(List<Entry> returnedEntries, Object ctx) {
        try {
            this.internalReadEntriesComplete(returnedEntries);
        }
        catch (Throwable throwable) {
            log.error("[{}] Fallback to readEntriesFailed for exception in readEntriesComplete", (Object)this, (Object)throwable);
            this.readEntriesFailed(ManagedLedgerException.getManagedLedgerException(throwable), ctx);
        }
    }

    @Override
    public void readEntriesFailed(ManagedLedgerException exception, Object ctx) {
        try {
            this.internalReadEntriesFailed(exception, ctx);
        }
        catch (Throwable throwable) {
            this.fail(ManagedLedgerException.getManagedLedgerException(throwable), ctx);
        }
    }

    private void internalReadEntriesFailed(ManagedLedgerException exception, Object ctx) {
        this.cursor.readOperationCompleted();
        if (!this.entries.isEmpty()) {
            this.complete(ctx);
        } else if (!this.cursor.isClosed() && this.cursor.getConfig().isAutoSkipNonRecoverableData() && exception instanceof ManagedLedgerException.NonRecoverableLedgerException) {
            Position nexReadPosition;
            log.warn("[{}][{}] read failed from ledger at position:{} : {}", new Object[]{this.cursor.ledger.getName(), this.cursor.getName(), this.readPosition, exception.getMessage()});
            ManagedLedgerImpl ledger = (ManagedLedgerImpl)this.cursor.getManagedLedger();
            Long lostLedger = null;
            if (exception instanceof ManagedLedgerException.LedgerNotExistException) {
                nexReadPosition = this.cursor.getNextLedgerPosition(this.readPosition.getLedgerId());
                lostLedger = this.readPosition.ledgerId;
            } else {
                nexReadPosition = ledger.getValidPositionAfterSkippedEntries(this.readPosition, this.count);
            }
            if (nexReadPosition == null) {
                this.fail(exception, ctx);
                return;
            }
            this.updateReadPosition(nexReadPosition);
            if (lostLedger != null) {
                this.cursor.getManagedLedger().skipNonRecoverableLedger(lostLedger);
            }
            this.checkReadCompletion();
        } else {
            if (!(exception instanceof ManagedLedgerException.TooManyRequestsException)) {
                log.warn("[{}][{}] read failed from ledger at position:{}", new Object[]{this.cursor.ledger.getName(), this.cursor.getName(), this.readPosition, exception});
            } else if (log.isDebugEnabled()) {
                log.debug("[{}][{}] read throttled failed from ledger at position:{}", new Object[]{this.cursor.ledger.getName(), this.cursor.getName(), this.readPosition});
            }
            this.fail(exception, ctx);
        }
    }

    void updateReadPosition(Position newReadPosition) {
        this.nextReadPosition = (PositionImpl)newReadPosition;
        this.cursor.setReadPosition(this.nextReadPosition);
    }

    void checkReadCompletion() {
        if (this.entries.size() < this.count && this.cursor.hasMoreEntries() && this.maxPosition.compareTo(this.readPosition) > 0) {
            this.cursor.ledger.getExecutor().execute(() -> {
                this.readPosition = this.cursor.ledger.startReadOperationOnLedger(this.nextReadPosition);
                this.cursor.ledger.asyncReadEntries(this);
            });
        } else {
            try {
                this.cursor.readOperationCompleted();
            }
            finally {
                this.complete(this.ctx);
            }
        }
    }

    public int getNumberOfEntriesToRead() {
        return this.count - this.entries.size();
    }

    private OpReadEntry(Recycler.Handle<OpReadEntry> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }

    private OpReadEntry() {
        this.recyclerHandle = null;
        this.callback = new AsyncCallbacks.ReadEntriesCallback(){

            @Override
            public void readEntriesComplete(List<Entry> entries, Object ctx) {
            }

            @Override
            public void readEntriesFailed(ManagedLedgerException exception, Object ctx) {
            }
        };
    }

    public void recycle() {
        if (this.recyclerHandle == null) {
            return;
        }
        this.id = -1;
        this.count = 0;
        this.cursor = null;
        this.readPosition = null;
        this.callback = null;
        this.ctx = null;
        this.entries = null;
        this.nextReadPosition = null;
        this.maxPosition = null;
        this.skipCondition = null;
        this.skipOpenLedgerFullyAcked = false;
        this.recyclerHandle.recycle((Object)this);
    }

    private void complete(Object ctx) {
        this.cursor.ledger.getExecutor().execute(() -> {
            try {
                this.callback.readEntriesComplete(this.entries, ctx);
                this.recycle();
            }
            catch (Throwable throwable) {
                log.error("[{}] readEntriesComplete failed (last position: {})", new Object[]{this, this.lastEntryPosition(), throwable});
            }
        });
    }

    private void fail(ManagedLedgerException e, Object ctx) {
        try {
            this.callback.readEntriesFailed(e, ctx);
            this.cursor.ledger.mbean.recordReadEntriesError();
            this.recycle();
        }
        catch (Throwable throwable) {
            log.error("[{}] readEntriesFailed failed (exception: {})", new Object[]{this, e.getMessage(), throwable});
        }
    }

    public String toString() {
        ManagedCursorImpl cursor = this.cursor;
        PositionImpl readPosition = this.readPosition;
        PositionImpl nextReadPosition = this.nextReadPosition;
        List<Entry> entries = this.entries;
        PositionImpl maxPosition = this.maxPosition;
        int count = this.count;
        if (cursor != null) {
            return cursor.ledger.getName() + " " + cursor.getName() + "{ readPosition: " + String.valueOf(readPosition != null ? readPosition : "(null)") + ", nextReadPosition: " + String.valueOf(nextReadPosition != null ? nextReadPosition : "(null)") + ", maxPosition: " + String.valueOf(maxPosition != null ? maxPosition : "(null)") + ", entries count: " + String.valueOf(entries != null ? Integer.valueOf(entries.size()) : "(null)") + ", count: " + count + " }";
        }
        return "(null)";
    }

    private String lastEntryPosition() {
        List<Entry> entries = this.entries;
        if (entries != null) {
            return entries.isEmpty() ? "(empty)" : entries.get(entries.size() - 1).getPosition().toString();
        }
        return "(null)";
    }
}

