/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import io.trino.decoder.DecoderColumnHandle;
import io.trino.decoder.FieldValueProvider;
import io.trino.decoder.FieldValueProviders;
import io.trino.spi.block.Block;
import io.trino.spi.block.Int128ArrayBlock;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.type.Int128;
import io.trino.spi.type.Type;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.ManagedLedgerFactory;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.ReadOnlyCursor;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.bookkeeper.mledger.impl.ReadOnlyCursorImpl;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.schema.KeyValueSchemaInfo;
import org.apache.pulsar.common.api.raw.MessageParser;
import org.apache.pulsar.common.api.raw.RawMessage;
import org.apache.pulsar.common.api.raw.RawMessageIdImpl;
import org.apache.pulsar.common.api.raw.RawMessageImpl;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.OffloadPoliciesImpl;
import org.apache.pulsar.common.protocol.schema.BytesSchemaVersion;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.schema.KeyValueEncodingType;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashMap;
import org.apache.pulsar.sql.presto.PulsarColumnHandle;
import org.apache.pulsar.sql.presto.PulsarConnectorCache;
import org.apache.pulsar.sql.presto.PulsarConnectorConfig;
import org.apache.pulsar.sql.presto.PulsarConnectorMetricsTracker;
import org.apache.pulsar.sql.presto.PulsarDispatchingRowDecoderFactory;
import org.apache.pulsar.sql.presto.PulsarFieldValueProviders;
import org.apache.pulsar.sql.presto.PulsarInternalColumn;
import org.apache.pulsar.sql.presto.PulsarRowDecoder;
import org.apache.pulsar.sql.presto.PulsarSplit;
import org.apache.pulsar.sql.presto.PulsarSqlSchemaInfoProvider;
import org.apache.pulsar.sql.presto.util.CacheSizeAllocator;
import org.apache.pulsar.sql.presto.util.NoStrictCacheSizeAllocator;
import org.apache.pulsar.sql.presto.util.NullCacheSizeAllocator;
import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.SpscArrayQueue;

public class PulsarRecordCursor
implements RecordCursor {
    private List<PulsarColumnHandle> columnHandles;
    private PulsarSplit pulsarSplit;
    private PulsarConnectorConfig pulsarConnectorConfig;
    private ReadOnlyCursor cursor;
    private SpscArrayQueue<RawMessage> messageQueue;
    private CacheSizeAllocator messageQueueCacheSizeAllocator;
    private SpscArrayQueue<Entry> entryQueue;
    private CacheSizeAllocator entryQueueCacheSizeAllocator;
    private RawMessage currentMessage;
    private int maxBatchSize;
    private long completedBytes = 0L;
    private ReadEntries readEntries;
    private DeserializeEntries deserializeEntries;
    private TopicName topicName;
    private PulsarConnectorMetricsTracker metricsTracker;
    private boolean readOffloaded;
    private long startTime;
    private final long splitSize;
    private long entriesProcessed = 0L;
    private int partition = -1;
    private volatile Throwable deserializingError;
    private PulsarSqlSchemaInfoProvider schemaInfoProvider;
    private FieldValueProvider[] currentRowValues = null;
    PulsarDispatchingRowDecoderFactory decoderFactory;
    protected ConcurrentOpenHashMap<String, ChunkedMessageCtx> chunkedMessagesMap = ConcurrentOpenHashMap.newBuilder().build();
    private static final Logger log = Logger.get(PulsarRecordCursor.class);

    public PulsarRecordCursor(List<PulsarColumnHandle> columnHandles, PulsarSplit pulsarSplit, PulsarConnectorConfig pulsarConnectorConfig, PulsarDispatchingRowDecoderFactory decoderFactory) {
        PulsarConnectorCache pulsarConnectorCache;
        this.splitSize = pulsarSplit.getSplitSize();
        this.startTime = System.nanoTime();
        try {
            pulsarConnectorCache = PulsarConnectorCache.getConnectorCache(pulsarConnectorConfig);
        }
        catch (Exception e) {
            log.error((Throwable)e, "Failed to initialize Pulsar connector cache");
            this.close();
            throw new RuntimeException(e);
        }
        OffloadPoliciesImpl offloadPolicies = pulsarSplit.getOffloadPolicies();
        if (offloadPolicies != null) {
            offloadPolicies.setOffloadersDirectory(pulsarConnectorConfig.getOffloadersDirectory());
            offloadPolicies.setManagedLedgerOffloadMaxThreads(Integer.valueOf(pulsarConnectorConfig.getManagedLedgerOffloadMaxThreads()));
        }
        this.initialize(columnHandles, pulsarSplit, pulsarConnectorConfig, pulsarConnectorCache.getManagedLedgerFactory(), pulsarConnectorCache.getManagedLedgerConfig(TopicName.get((String)"persistent", (NamespaceName)NamespaceName.get((String)pulsarSplit.getSchemaName()), (String)pulsarSplit.getTableName()).getNamespaceObject(), offloadPolicies, pulsarConnectorConfig), new PulsarConnectorMetricsTracker(pulsarConnectorCache.getStatsProvider()));
        this.decoderFactory = decoderFactory;
        this.initEntryCacheSizeAllocator(pulsarConnectorConfig);
    }

    PulsarRecordCursor(List<PulsarColumnHandle> columnHandles, PulsarSplit pulsarSplit, PulsarConnectorConfig pulsarConnectorConfig, ManagedLedgerFactory managedLedgerFactory, ManagedLedgerConfig managedLedgerConfig, PulsarConnectorMetricsTracker pulsarConnectorMetricsTracker, PulsarDispatchingRowDecoderFactory decoderFactory) {
        this.splitSize = pulsarSplit.getSplitSize();
        this.initialize(columnHandles, pulsarSplit, pulsarConnectorConfig, managedLedgerFactory, managedLedgerConfig, pulsarConnectorMetricsTracker);
        this.decoderFactory = decoderFactory;
    }

    private void initialize(List<PulsarColumnHandle> columnHandles, PulsarSplit pulsarSplit, PulsarConnectorConfig pulsarConnectorConfig, ManagedLedgerFactory managedLedgerFactory, ManagedLedgerConfig managedLedgerConfig, PulsarConnectorMetricsTracker pulsarConnectorMetricsTracker) {
        this.columnHandles = columnHandles;
        this.currentRowValues = new FieldValueProvider[columnHandles.size()];
        this.pulsarSplit = pulsarSplit;
        this.partition = TopicName.getPartitionIndex((String)pulsarSplit.getTableName());
        this.pulsarConnectorConfig = pulsarConnectorConfig;
        this.maxBatchSize = pulsarConnectorConfig.getMaxEntryReadBatchSize();
        this.messageQueue = new SpscArrayQueue(pulsarConnectorConfig.getMaxSplitMessageQueueSize());
        this.entryQueue = new SpscArrayQueue(pulsarConnectorConfig.getMaxSplitEntryQueueSize());
        this.topicName = TopicName.get((String)"persistent", (NamespaceName)NamespaceName.get((String)pulsarSplit.getSchemaName()), (String)pulsarSplit.getTableName());
        this.metricsTracker = pulsarConnectorMetricsTracker;
        this.readOffloaded = pulsarConnectorConfig.getManagedLedgerOffloadDriver() != null;
        this.pulsarConnectorConfig = pulsarConnectorConfig;
        this.initEntryCacheSizeAllocator(pulsarConnectorConfig);
        try {
            this.schemaInfoProvider = new PulsarSqlSchemaInfoProvider(this.topicName, pulsarConnectorConfig.getPulsarAdmin());
        }
        catch (PulsarClientException e) {
            log.error((Throwable)e, "Failed to init  Pulsar SchemaInfo Provider");
            throw new RuntimeException(e);
        }
        log.info("Initializing split with parameters: %s", new Object[]{pulsarSplit});
        try {
            this.cursor = this.getCursor(TopicName.get((String)"persistent", (NamespaceName)NamespaceName.get((String)pulsarSplit.getSchemaName()), (String)pulsarSplit.getTableName()), pulsarSplit.getStartPosition(), managedLedgerFactory, managedLedgerConfig);
        }
        catch (InterruptedException | ManagedLedgerException e) {
            log.error((Throwable)e, "Failed to get read only cursor");
            this.close();
            throw new RuntimeException(e);
        }
    }

    private ReadOnlyCursor getCursor(TopicName topicName, Position startPosition, ManagedLedgerFactory managedLedgerFactory, ManagedLedgerConfig managedLedgerConfig) throws ManagedLedgerException, InterruptedException {
        ReadOnlyCursor cursor = managedLedgerFactory.openReadOnlyCursor(topicName.getPersistenceNamingEncoding(), startPosition, managedLedgerConfig);
        return cursor;
    }

    public long getCompletedBytes() {
        return this.completedBytes;
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    public Type getType(int field) {
        Preconditions.checkArgument((field < this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
        return this.columnHandles.get(field).getType();
    }

    @VisibleForTesting
    public void setPulsarSqlSchemaInfoProvider(PulsarSqlSchemaInfoProvider schemaInfoProvider) {
        this.schemaInfoProvider = schemaInfoProvider;
    }

    private boolean entryExceedSplitEndPosition(Entry entry) {
        return ((PositionImpl)entry.getPosition()).compareTo(this.pulsarSplit.getEndPosition()) >= 0;
    }

    private boolean haveAvailableCacheSize(CacheSizeAllocator cacheSizeAllocator, SpscArrayQueue queue) {
        if (cacheSizeAllocator instanceof NullCacheSizeAllocator) {
            return true;
        }
        return cacheSizeAllocator.getAvailableCacheSize() > 0L || queue.size() == 0;
    }

    /*
     * WARNING - void declaration
     */
    public boolean advanceNextPosition() {
        if (this.readEntries == null) {
            this.deserializeEntries = new DeserializeEntries();
            this.deserializeEntries.setUncaughtExceptionHandler((t, ex) -> {
                this.deserializingError = ex;
            });
            this.deserializeEntries.start();
            this.readEntries = new ReadEntries();
            this.readEntries.run();
        }
        if (this.currentMessage != null) {
            this.currentMessage.release();
            this.currentMessage = null;
        }
        while (true) {
            if (this.readEntries.hasFinished()) {
                return false;
            }
            if (this.messageQueue.capacity() - this.messageQueue.size() > 0) {
                this.readEntries.run();
            }
            this.currentMessage = (RawMessage)this.messageQueue.poll();
            if (this.currentMessage != null) break;
            if (this.deserializingError != null) {
                throw new RuntimeException(this.deserializingError);
            }
            try {
                Thread.sleep(1L);
                this.metricsTracker.register_MESSAGE_QUEUE_DEQUEUE_WAIT_TIME(1L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.messageQueueCacheSizeAllocator.release(this.currentMessage.getData().readableBytes());
        this.metricsTracker.start_RECORD_DESERIALIZE_TIME();
        SchemaInfo schemaInfo = this.getSchemaInfo(this.pulsarSplit);
        HashMap<DecoderColumnHandle, FieldValueProvider> currentRowValuesMap = new HashMap<DecoderColumnHandle, FieldValueProvider>();
        if (schemaInfo.getType().equals((Object)SchemaType.KEY_VALUE)) {
            ByteBuf keyByteBuf;
            KeyValueEncodingType keyValueEncodingType = KeyValueSchemaInfo.decodeKeyValueEncodingType((SchemaInfo)schemaInfo);
            if (Objects.equals(keyValueEncodingType, KeyValueEncodingType.INLINE)) {
                ByteBuf dataPayload = this.currentMessage.getData();
                int keyLength = dataPayload.readInt();
                keyByteBuf = dataPayload.readSlice(keyLength);
                int valueLength = dataPayload.readInt();
                ByteBuf byteBuf = dataPayload.readSlice(valueLength);
            } else {
                keyByteBuf = (ByteBuf)this.currentMessage.getKeyBytes().get();
                ByteBuf byteBuf = this.currentMessage.getData();
            }
            KeyValue kvSchemaInfo = KeyValueSchemaInfo.decodeKeyValueSchemaInfo((SchemaInfo)schemaInfo);
            Set keyColumnHandles = (Set)this.columnHandles.stream().filter(col -> !col.isInternal()).filter(col -> PulsarColumnHandle.HandleKeyValueType.KEY.equals((Object)col.getHandleKeyValueType())).collect(ImmutableSet.toImmutableSet());
            PulsarRowDecoder keyDecoder = null;
            if (keyColumnHandles.size() > 0) {
                keyDecoder = this.decoderFactory.createRowDecoder(this.topicName, (SchemaInfo)kvSchemaInfo.getKey(), keyColumnHandles);
            }
            Set valueColumnHandles = (Set)this.columnHandles.stream().filter(col -> !col.isInternal()).filter(col -> PulsarColumnHandle.HandleKeyValueType.VALUE.equals((Object)col.getHandleKeyValueType())).collect(ImmutableSet.toImmutableSet());
            PulsarRowDecoder valueDecoder = null;
            if (valueColumnHandles.size() > 0) {
                valueDecoder = this.decoderFactory.createRowDecoder(this.topicName, (SchemaInfo)kvSchemaInfo.getValue(), valueColumnHandles);
            }
            if (keyColumnHandles.size() > 0) {
                Optional<Map<DecoderColumnHandle, FieldValueProvider>> decodedKey = keyDecoder.decodeRow(keyByteBuf);
                decodedKey.ifPresent(currentRowValuesMap::putAll);
            }
            if (valueColumnHandles.size() > 0) {
                void var4_15;
                Optional<Map<DecoderColumnHandle, FieldValueProvider>> decodedValue = valueDecoder.decodeRow((ByteBuf)var4_15);
                decodedValue.ifPresent(currentRowValuesMap::putAll);
            }
        } else {
            PulsarRowDecoder messageDecoder = this.decoderFactory.createRowDecoder(this.topicName, schemaInfo, (Set)this.columnHandles.stream().filter(col -> !col.isInternal()).filter(col -> PulsarColumnHandle.HandleKeyValueType.NONE.equals((Object)col.getHandleKeyValueType())).collect(ImmutableSet.toImmutableSet()));
            Optional<Map<DecoderColumnHandle, FieldValueProvider>> optional = messageDecoder.decodeRow(this.currentMessage.getData());
            optional.ifPresent(currentRowValuesMap::putAll);
        }
        for (DecoderColumnHandle decoderColumnHandle : this.columnHandles) {
            if (!decoderColumnHandle.isInternal()) continue;
            if (PulsarInternalColumn.PARTITION.getName().equals(decoderColumnHandle.getName())) {
                currentRowValuesMap.put(decoderColumnHandle, FieldValueProviders.longValueProvider((long)this.partition));
                continue;
            }
            if (PulsarInternalColumn.EVENT_TIME.getName().equals(decoderColumnHandle.getName())) {
                currentRowValuesMap.put(decoderColumnHandle, PulsarFieldValueProviders.timeValueProvider(this.currentMessage.getEventTime(), this.currentMessage.getEventTime() == 0L));
                continue;
            }
            if (PulsarInternalColumn.PUBLISH_TIME.getName().equals(decoderColumnHandle.getName())) {
                currentRowValuesMap.put(decoderColumnHandle, PulsarFieldValueProviders.timeValueProvider(this.currentMessage.getPublishTime(), this.currentMessage.getPublishTime() == 0L));
                continue;
            }
            if (PulsarInternalColumn.MESSAGE_ID.getName().equals(decoderColumnHandle.getName())) {
                currentRowValuesMap.put(decoderColumnHandle, FieldValueProviders.bytesValueProvider((byte[])this.currentMessage.getMessageId().toString().getBytes()));
                continue;
            }
            if (PulsarInternalColumn.SEQUENCE_ID.getName().equals(decoderColumnHandle.getName())) {
                currentRowValuesMap.put(decoderColumnHandle, FieldValueProviders.longValueProvider((long)this.currentMessage.getSequenceId()));
                continue;
            }
            if (PulsarInternalColumn.PRODUCER_NAME.getName().equals(decoderColumnHandle.getName())) {
                currentRowValuesMap.put(decoderColumnHandle, FieldValueProviders.bytesValueProvider((byte[])this.currentMessage.getProducerName().getBytes()));
                continue;
            }
            if (PulsarInternalColumn.KEY.getName().equals(decoderColumnHandle.getName())) {
                String key = this.currentMessage.getKey().orElse(null);
                currentRowValuesMap.put(decoderColumnHandle, FieldValueProviders.bytesValueProvider((byte[])(key == null ? null : key.getBytes())));
                continue;
            }
            if (PulsarInternalColumn.PROPERTIES.getName().equals(decoderColumnHandle.getName())) {
                try {
                    currentRowValuesMap.put(decoderColumnHandle, FieldValueProviders.bytesValueProvider((byte[])new ObjectMapper().writeValueAsBytes((Object)this.currentMessage.getProperties())));
                    continue;
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
            throw new IllegalArgumentException("unknown internal field " + decoderColumnHandle.getName());
        }
        for (int i = 0; i < this.columnHandles.size(); ++i) {
            ColumnHandle columnHandle = (ColumnHandle)this.columnHandles.get(i);
            this.currentRowValues[i] = (FieldValueProvider)currentRowValuesMap.get(columnHandle);
        }
        this.metricsTracker.incr_NUM_RECORD_DESERIALIZED();
        this.metricsTracker.end_RECORD_DESERIALIZE_TIME();
        return true;
    }

    private SchemaInfo getSchemaInfo(PulsarSplit pulsarSplit) {
        SchemaInfo schemaInfo = this.getBytesSchemaInfo(pulsarSplit.getSchemaType(), pulsarSplit.getSchemaName());
        if (schemaInfo != null) {
            return schemaInfo;
        }
        try {
            schemaInfo = this.currentMessage.getSchemaVersion() == null || this.currentMessage.getSchemaVersion().length == 0 ? pulsarSplit.getSchemaInfo() : this.schemaInfoProvider.getSchemaByVersion(this.currentMessage.getSchemaVersion()).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        if (schemaInfo == null) {
            String schemaVersion = this.currentMessage.getSchemaVersion() == null ? "null" : BytesSchemaVersion.of((byte[])this.currentMessage.getSchemaVersion()).toString();
            throw new RuntimeException("The specific version (" + schemaVersion + ") schema of the table " + pulsarSplit.getTableName() + " is null");
        }
        return schemaInfo;
    }

    private SchemaInfo getBytesSchemaInfo(SchemaType schemaType, String schemaName) {
        if (!schemaType.equals((Object)SchemaType.BYTES) && !schemaType.equals((Object)SchemaType.NONE)) {
            return null;
        }
        if (schemaName.equals(Schema.BYTES.getSchemaInfo().getName())) {
            return Schema.BYTES.getSchemaInfo();
        }
        if (schemaName.equals(Schema.BYTEBUFFER.getSchemaInfo().getName())) {
            return Schema.BYTEBUFFER.getSchemaInfo();
        }
        return Schema.BYTES.getSchemaInfo();
    }

    public boolean getBoolean(int field) {
        return this.getFieldValueProvider(field, Boolean.TYPE).getBoolean();
    }

    public long getLong(int field) {
        return this.getFieldValueProvider(field, Long.TYPE).getLong();
    }

    public double getDouble(int field) {
        return this.getFieldValueProvider(field, Double.TYPE).getDouble();
    }

    public Slice getSlice(int field) {
        return this.getFieldValueProvider(field, Slice.class).getSlice();
    }

    private FieldValueProvider getFieldValueProvider(int fieldIndex, Class<?> expectedType) {
        Preconditions.checkArgument((fieldIndex < this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
        this.checkFieldType(fieldIndex, expectedType);
        return this.currentRowValues[fieldIndex];
    }

    private FieldValueProvider getFieldValueProvider(int fieldIndex) {
        Preconditions.checkArgument((fieldIndex < this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
        return this.currentRowValues[fieldIndex];
    }

    public Object getObject(int field) {
        Block block = this.getFieldValueProvider(field).getBlock();
        if (block instanceof Int128ArrayBlock) {
            return Int128.valueOf((long)block.getLong(0, 0), (long)block.getLong(0, 8));
        }
        return block;
    }

    public boolean isNull(int field) {
        FieldValueProvider provider = this.currentRowValues[field];
        return provider == null || provider.isNull();
    }

    public void close() {
        log.info("Closing cursor record");
        if (this.deserializeEntries != null) {
            this.deserializeEntries.close().whenComplete((r, t) -> {
                if (this.entryQueue != null) {
                    this.entryQueue.drain(Entry::release);
                }
                if (this.messageQueue != null) {
                    this.messageQueue.drain(RawMessage::release);
                }
                if (this.currentMessage != null) {
                    this.currentMessage.release();
                }
            });
        }
        if (this.cursor != null) {
            try {
                this.cursor.close();
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
        if (this.metricsTracker != null) {
            this.metricsTracker.register_TOTAL_EXECUTION_TIME(System.nanoTime() - this.startTime);
            this.metricsTracker.close();
        }
    }

    private void checkFieldType(int field, Class<?> expected) {
        Class actual = this.getType(field).getJavaType();
        Preconditions.checkArgument((actual == expected ? 1 : 0) != 0, (String)"Expected field %s to be type %s but is %s", (Object)field, expected, (Object)actual);
    }

    private void initEntryCacheSizeAllocator(PulsarConnectorConfig connectorConfig) {
        if (connectorConfig.getMaxSplitQueueSizeBytes() >= 0L) {
            this.entryQueueCacheSizeAllocator = new NoStrictCacheSizeAllocator(connectorConfig.getMaxSplitQueueSizeBytes() / 2L);
            this.messageQueueCacheSizeAllocator = new NoStrictCacheSizeAllocator(connectorConfig.getMaxSplitQueueSizeBytes() / 2L);
            log.info("Init cacheSizeAllocator with maxSplitEntryQueueSizeBytes %d.", new Object[]{connectorConfig.getMaxSplitQueueSizeBytes()});
        } else {
            this.entryQueueCacheSizeAllocator = new NullCacheSizeAllocator();
            this.messageQueueCacheSizeAllocator = new NullCacheSizeAllocator();
            log.info("Init cacheSizeAllocator with NullCacheSizeAllocator.");
        }
    }

    private RawMessage processChunkedMessages(RawMessage message) {
        ChunkedMessageCtx chunkedMsgCtx;
        String uuid = message.getUUID();
        int chunkId = message.getChunkId();
        int totalChunkMsgSize = message.getTotalChunkMsgSize();
        int numChunks = message.getNumChunksFromMsg();
        RawMessageIdImpl rawMessageId = (RawMessageIdImpl)message.getMessageId();
        if (rawMessageId.getLedgerId() > this.pulsarSplit.getEndPositionLedgerId() && !this.chunkedMessagesMap.containsKey((Object)uuid)) {
            message.release();
            return null;
        }
        if (chunkId == 0) {
            ByteBuf chunkedMsgBuffer = Unpooled.directBuffer((int)totalChunkMsgSize, (int)totalChunkMsgSize);
            this.chunkedMessagesMap.computeIfAbsent((Object)uuid, key -> ChunkedMessageCtx.get(numChunks, chunkedMsgBuffer));
        }
        if ((chunkedMsgCtx = (ChunkedMessageCtx)this.chunkedMessagesMap.get((Object)uuid)) == null || chunkedMsgCtx.chunkedMsgBuffer == null || chunkId != chunkedMsgCtx.lastChunkedMessageId + 1 || chunkId >= numChunks) {
            log.info("Received unexpected chunk. messageId: %s, last-chunk-id: %s chunkId: %s, totalChunks: %s", new Object[]{message.getMessageId(), chunkedMsgCtx != null ? Integer.valueOf(chunkedMsgCtx.lastChunkedMessageId) : null, chunkId, numChunks});
            if (chunkedMsgCtx != null) {
                if (chunkedMsgCtx.chunkedMsgBuffer != null) {
                    ReferenceCountUtil.safeRelease((Object)chunkedMsgCtx.chunkedMsgBuffer);
                }
                chunkedMsgCtx.recycle();
            }
            this.chunkedMessagesMap.remove((Object)uuid);
            message.release();
            return null;
        }
        chunkedMsgCtx.chunkedMsgBuffer.writeBytes(message.getData());
        chunkedMsgCtx.lastChunkedMessageId = chunkId;
        if (chunkId != numChunks - 1) {
            message.release();
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Chunked message completed. chunkId: %s, totalChunks: %s, msgId: %s, sequenceId: %s", new Object[]{chunkId, numChunks, rawMessageId, message.getSequenceId()});
        }
        this.chunkedMessagesMap.remove((Object)uuid);
        ByteBuf unCompressedPayload = chunkedMsgCtx.chunkedMsgBuffer;
        chunkedMsgCtx.recycle();
        return ((RawMessageImpl)message).updatePayloadForChunkedMessage(unCompressedPayload);
    }

    @VisibleForTesting
    class ReadEntries
    implements AsyncCallbacks.ReadEntriesCallback {
        private boolean isDone = false;
        private final AtomicLong outstandingReadsRequests = new AtomicLong(1L);

        ReadEntries() {
        }

        public void run() {
            if (this.outstandingReadsRequests.get() > 0L) {
                if (!PulsarRecordCursor.this.cursor.hasMoreEntries() || ((PositionImpl)PulsarRecordCursor.this.cursor.getReadPosition()).compareTo(PulsarRecordCursor.this.pulsarSplit.getEndPosition()) >= 0 && PulsarRecordCursor.this.chunkedMessagesMap.isEmpty()) {
                    this.isDone = true;
                } else {
                    int batchSize = Math.min(PulsarRecordCursor.this.maxBatchSize, PulsarRecordCursor.this.entryQueue.capacity() - PulsarRecordCursor.this.entryQueue.size());
                    if (batchSize > 0) {
                        ReadOnlyCursorImpl readOnlyCursorImpl = (ReadOnlyCursorImpl)PulsarRecordCursor.this.cursor;
                        if (!PulsarRecordCursor.this.readOffloaded && readOnlyCursorImpl.getCurrentLedgerInfo().hasOffloadContext()) {
                            log.warn("Ledger %s is offloaded for topic %s. Ignoring it because offloader is not configured", new Object[]{readOnlyCursorImpl.getCurrentLedgerInfo().getLedgerId(), PulsarRecordCursor.this.pulsarSplit.getTableName()});
                            long numEntries = readOnlyCursorImpl.getCurrentLedgerInfo().getEntries();
                            long entriesToSkip = numEntries - ((PositionImpl)PulsarRecordCursor.this.cursor.getReadPosition()).getEntryId() + 1L;
                            PulsarRecordCursor.this.cursor.skipEntries(Math.toIntExact(entriesToSkip));
                            PulsarRecordCursor.this.entriesProcessed += entriesToSkip;
                        } else {
                            if (!PulsarRecordCursor.this.haveAvailableCacheSize(PulsarRecordCursor.this.entryQueueCacheSizeAllocator, PulsarRecordCursor.this.entryQueue)) {
                                PulsarRecordCursor.this.metricsTracker.incr_READ_ATTEMPTS_FAIL();
                                return;
                            }
                            this.outstandingReadsRequests.decrementAndGet();
                            PulsarRecordCursor.this.cursor.asyncReadEntries(batchSize, PulsarRecordCursor.this.entryQueueCacheSizeAllocator.getAvailableCacheSize(), this, System.nanoTime(), PositionImpl.LATEST);
                        }
                        PulsarRecordCursor.this.metricsTracker.incr_READ_ATTEMPTS_SUCCESS();
                    } else {
                        PulsarRecordCursor.this.metricsTracker.incr_READ_ATTEMPTS_FAIL();
                    }
                }
            }
        }

        @Override
        public void readEntriesComplete(final List<Entry> entries, Object ctx) {
            PulsarRecordCursor.this.entryQueue.fill((MessagePassingQueue.Supplier)new MessagePassingQueue.Supplier<Entry>(){
                private int i = 0;

                public Entry get() {
                    Entry entry = (Entry)entries.get(this.i);
                    ++this.i;
                    PulsarRecordCursor.this.entryQueueCacheSizeAllocator.allocate(entry.getLength());
                    return entry;
                }
            }, entries.size());
            this.outstandingReadsRequests.incrementAndGet();
            PulsarRecordCursor.this.metricsTracker.register_READ_LATENCY_PER_BATCH_SUCCESS(System.nanoTime() - (Long)ctx);
            PulsarRecordCursor.this.metricsTracker.incr_NUM_ENTRIES_PER_BATCH_SUCCESS(entries.size());
        }

        public boolean hasFinished() {
            return PulsarRecordCursor.this.messageQueue.isEmpty() && this.isDone && this.outstandingReadsRequests.get() >= 1L && PulsarRecordCursor.this.splitSize <= PulsarRecordCursor.this.entriesProcessed && PulsarRecordCursor.this.chunkedMessagesMap.isEmpty();
        }

        @Override
        public void readEntriesFailed(ManagedLedgerException exception, Object ctx) {
            if (log.isDebugEnabled()) {
                log.debug((Throwable)exception, "Failed to read entries from topic %s", new Object[]{PulsarRecordCursor.this.topicName.toString()});
            }
            this.outstandingReadsRequests.incrementAndGet();
            PulsarRecordCursor.this.metricsTracker.register_READ_LATENCY_PER_BATCH_FAIL(System.nanoTime() - (Long)ctx);
            PulsarRecordCursor.this.metricsTracker.incr_NUM_ENTRIES_PER_BATCH_FAIL(PulsarRecordCursor.this.maxBatchSize);
        }
    }

    @VisibleForTesting
    class DeserializeEntries
    extends Thread {
        private final AtomicBoolean isRunning;
        private final CompletableFuture<Void> closeHandle;

        public DeserializeEntries() {
            super("deserialize-thread-split-" + PulsarRecordCursor.this.pulsarSplit.getSplitId());
            this.isRunning = new AtomicBoolean(false);
            this.closeHandle = new CompletableFuture();
        }

        @Override
        public void start() {
            if (this.isRunning.compareAndSet(false, true)) {
                super.start();
            }
        }

        public CompletableFuture<Void> close() {
            if (this.isRunning.compareAndSet(true, false)) {
                super.interrupt();
            }
            return this.closeHandle;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (true) lbl-1000:
                // 3 sources

                {
                    if (!this.isRunning.get()) {
                        this.closeHandle.complete(null);
                        return;
                    }
                    read = PulsarRecordCursor.this.entryQueue.drain((MessagePassingQueue.Consumer)new MessagePassingQueue.Consumer<Entry>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void accept(Entry entry) {
                            try {
                                PulsarRecordCursor.this.entryQueueCacheSizeAllocator.release(entry.getLength());
                                long bytes = entry.getDataBuffer().readableBytes();
                                PulsarRecordCursor.this.completedBytes += bytes;
                                PulsarRecordCursor.this.metricsTracker.register_BYTES_READ(bytes);
                                if (PulsarRecordCursor.this.entryExceedSplitEndPosition(entry) && PulsarRecordCursor.this.chunkedMessagesMap.isEmpty()) {
                                    return;
                                }
                                PulsarRecordCursor.this.metricsTracker.start_ENTRY_DESERIALIZE_TIME();
                                try {
                                    MessageParser.parseMessage((TopicName)PulsarRecordCursor.this.topicName, (long)entry.getLedgerId(), (long)entry.getEntryId(), (ByteBuf)entry.getDataBuffer(), message -> {
                                        try {
                                            PulsarRecordCursor.this.metricsTracker.start_MESSAGE_QUEUE_ENQUEUE_WAIT_TIME();
                                            if (message.getNumChunksFromMsg() > 1) {
                                                message = PulsarRecordCursor.this.processChunkedMessages(message);
                                            } else if (PulsarRecordCursor.this.entryExceedSplitEndPosition(entry)) {
                                                message.release();
                                                message = null;
                                            }
                                            if (message != null) {
                                                while (!PulsarRecordCursor.this.haveAvailableCacheSize(PulsarRecordCursor.this.messageQueueCacheSizeAllocator, PulsarRecordCursor.this.messageQueue) || !PulsarRecordCursor.this.messageQueue.offer((Object)message)) {
                                                    Thread.sleep(1L);
                                                }
                                                PulsarRecordCursor.this.messageQueueCacheSizeAllocator.allocate(message.getData().readableBytes());
                                            }
                                            PulsarRecordCursor.this.metricsTracker.end_MESSAGE_QUEUE_ENQUEUE_WAIT_TIME();
                                            PulsarRecordCursor.this.metricsTracker.incr_NUM_MESSAGES_DESERIALIZED_PER_ENTRY();
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                    }, (int)PulsarRecordCursor.this.pulsarConnectorConfig.getMaxMessageSize());
                                }
                                catch (IOException e) {
                                    log.error((Throwable)e, "Failed to parse message from pulsar topic %s", new Object[]{PulsarRecordCursor.this.topicName.toString()});
                                    throw new RuntimeException(e);
                                }
                                PulsarRecordCursor.this.metricsTracker.end_ENTRY_DESERIALIZE_TIME();
                                PulsarRecordCursor.this.metricsTracker.end_NUM_MESSAGES_DESERIALIZED_PER_ENTRY();
                            }
                            finally {
                                ++PulsarRecordCursor.this.entriesProcessed;
                                entry.release();
                            }
                        }
                    });
                    if (read > 0) continue;
                    try {
                        Thread.sleep(1L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    break;
                }
            }
            catch (Throwable ex) {
                PulsarRecordCursor.log.error(ex, "Stop running DeserializeEntries");
                this.closeHandle.completeExceptionally(ex);
                throw ex;
            }
            {
                ** while (true)
            }
        }
    }

    static class ChunkedMessageCtx {
        protected int totalChunks = -1;
        protected ByteBuf chunkedMsgBuffer;
        protected int lastChunkedMessageId = -1;
        private final Recycler.Handle<ChunkedMessageCtx> recyclerHandle;
        private static final Recycler<ChunkedMessageCtx> RECYCLER = new Recycler<ChunkedMessageCtx>(){

            protected ChunkedMessageCtx newObject(Recycler.Handle<ChunkedMessageCtx> handle) {
                return new ChunkedMessageCtx(handle);
            }
        };

        static ChunkedMessageCtx get(int numChunksFromMsg, ByteBuf chunkedMsgBuffer) {
            ChunkedMessageCtx ctx = (ChunkedMessageCtx)RECYCLER.get();
            ctx.totalChunks = numChunksFromMsg;
            ctx.chunkedMsgBuffer = chunkedMsgBuffer;
            return ctx;
        }

        private ChunkedMessageCtx(Recycler.Handle<ChunkedMessageCtx> recyclerHandle) {
            this.recyclerHandle = recyclerHandle;
        }

        public void recycle() {
            this.totalChunks = -1;
            this.chunkedMsgBuffer = null;
            this.lastChunkedMessageId = -1;
            this.recyclerHandle.recycle((Object)this);
        }
    }
}

