/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import java.util.ArrayList;
import java.util.List;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.TypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.ValueHandler;
import org.apache.qpid.server.protocol.v1_0.codec.VariableWidthTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;

public class ListConstructor
extends VariableWidthTypeConstructor<List<Object>> {
    private ListConstructor(int size) {
        super(size);
    }

    @Override
    public List<Object> construct(QpidByteBuffer in, ValueHandler handler) throws AmqpErrorException {
        int count;
        int size;
        long remaining = in.remaining();
        if (remaining < (long)(this.getSize() * 2)) {
            throw new AmqpErrorException(AmqpError.DECODE_ERROR, String.format("Not sufficient data for deserialization of 'list'. Expected at least %d bytes. Got %d bytes.", this.getSize(), remaining), new Object[0]);
        }
        if (this.getSize() == 1) {
            size = in.getUnsignedByte();
            count = in.getUnsignedByte();
        } else {
            size = in.getInt();
            count = in.getInt();
        }
        if ((remaining -= (long)this.getSize()) < (long)size) {
            throw new AmqpErrorException(AmqpError.DECODE_ERROR, String.format("Not sufficient data for deserialization of 'list'. Expected at least %d bytes. Got %d bytes.", size, remaining), new Object[0]);
        }
        return this.construct(in, handler, size, count);
    }

    protected List<Object> construct(QpidByteBuffer in, ValueHandler handler, int size, int count) throws AmqpErrorException {
        ArrayList<Object> list = new ArrayList<Object>(count);
        for (int i = 0; i < count; ++i) {
            list.add(handler.parse(in));
        }
        return list;
    }

    public static TypeConstructor getInstance(int size) {
        return new ListConstructor(size);
    }
}

