/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.util.Collection;
import java.util.Map;
import org.apache.qpid.server.exchange.DestinationReferrer;
import org.apache.qpid.server.filter.AMQInvalidArgumentException;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.MessageSender;
import org.apache.qpid.server.model.AlternateBinding;
import org.apache.qpid.server.model.Binding;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.DerivedAttribute;
import org.apache.qpid.server.model.DoOnConfigThread;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedOperation;
import org.apache.qpid.server.model.ManagedStatistic;
import org.apache.qpid.server.model.Param;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.StatisticType;
import org.apache.qpid.server.model.StatisticUnit;
import org.apache.qpid.server.queue.CreatingLinkInfo;
import org.apache.qpid.server.virtualhost.QueueManagingVirtualHost;

@ManagedObject(description="<p>An Exchange is a named entity within the Virtualhost which receives messages from producers and routes them to matching Queues within the Virtualhost.</p><p>The server provides a set of exchange types with each exchange type implementing a different routing algorithm.</p>", amqpName="org.apache.qpid.Exchange")
public interface Exchange<X extends Exchange<X>>
extends ConfiguredObject<X>,
MessageDestination,
DestinationReferrer,
MessageSender {
    public static final String CLASS_DESCRIPTION = "<p>An Exchange is a named entity within the Virtualhost which receives messages from producers and routes them to matching Queues within the Virtualhost.</p><p>The server provides a set of exchange types with each exchange type implementing a different routing algorithm.</p>";
    public static final String ALTERNATE_BINDING = "alternateBinding";
    public static final String DURABLE_BINDINGS = "durableBindings";
    public static final String UNROUTABLE_MESSAGE_BEHAVIOUR = "unroutableMessageBehaviour";
    public static final String CREATING_LINK_INFO = "creatingLinkInfo";
    public static final String UNKNOWN_EXCHANGE_DECLARE_ARGUMENT_BEHAVIOUR_NAME = "exchange.behaviourOnUnknownDeclareArgument";
    @ManagedContextDefault(name="exchange.behaviourOnUnknownDeclareArgument")
    public static final BehaviourOnUnknownDeclareArgument ON_UNKNOWN_EXCHANGE_DECLARE_OPTION = BehaviourOnUnknownDeclareArgument.FAIL;

    @ManagedAttribute(description="Provides an alternate destination that, depending on behaviour requested by the producer, may be used if a message arriving at this exchange cannot be routed to at least one queue.")
    public AlternateBinding getAlternateBinding();

    @ManagedAttribute(description="(AMQP 1.0 only) Default behaviour to apply when a message is not routed to any queues", defaultValue="DISCARD")
    public UnroutableMessageBehaviour getUnroutableMessageBehaviour();

    @DerivedAttribute
    public Collection<Binding> getBindings();

    public Collection<Binding> getPublishingLinks(MessageDestination var1);

    @DerivedAttribute(persist=true)
    public Collection<Binding> getDurableBindings();

    @ManagedAttribute(immutable=true, description="Information about the AMQP 1.0 Link that created this Exchange if any.")
    public CreatingLinkInfo getCreatingLinkInfo();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.COUNT, label="Bindings", description="Current number of bindings to this exchange.", metricName="bindings_total")
    public long getBindingCount();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.BYTES, label="Dropped", description="Total size of all unroutable messages dropped by this exchange.", metricName="dropped_bytes_count", resettable=true)
    public long getBytesDropped();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.BYTES, label="Inbound", description="Total size of messages received by this exchange.", metricName="inbound_bytes_count", resettable=true)
    public long getBytesIn();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.MESSAGES, label="Dropped", description="Number of unroutable messages dropped by this exchange.", metricName="dropped_messages_count", resettable=true)
    public long getMessagesDropped();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.MESSAGES, label="Inbound", description="Number of messages received by this exchange.", metricName="inbound_messages_count", resettable=true)
    public long getMessagesIn();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.COUNT, label="Producers", description="Number of producers to this exchange.", metricName="producers_count")
    public long getProducerCount();

    @ManagedOperation(changesConfiguredObjectState=true, description="Bind a given destination to exchange using a given bindingKey and arguments. Existing binding arguments are replaced when replaceExistingArguments=true")
    public boolean bind(@Param(name="destination", mandatory=true) String var1, @Param(name="bindingKey", mandatory=true) String var2, @Param(name="arguments", defaultValue="{}") Map<String, Object> var3, @Param(name="replaceExistingArguments", defaultValue="false") boolean var4);

    @ManagedOperation(changesConfiguredObjectState=true, description="Deletes the binding for a given destination with a given bindingKey")
    public boolean unbind(@Param(name="destination", mandatory=true) String var1, @Param(name="bindingKey", mandatory=true) String var2);

    @ManagedOperation(changesConfiguredObjectState=true, description="Resets exchange statistics")
    public void resetStatistics();

    public boolean isAutoDelete();

    @DoOnConfigThread
    public boolean addBinding(@Param(name="bindingKey") String var1, @Param(name="queue") Queue<?> var2, @Param(name="arguments") Map<String, Object> var3) throws AMQInvalidArgumentException;

    @DoOnConfigThread
    public boolean deleteBinding(@Param(name="bindingKey") String var1, @Param(name="queue") Queue<?> var2);

    @DoOnConfigThread
    public boolean hasBinding(@Param(name="bindingKey") String var1, @Param(name="queue") Queue<?> var2);

    @DoOnConfigThread
    public void replaceBinding(@Param(name="bindingKey") String var1, @Param(name="queue") Queue<?> var2, @Param(name="arguments") Map<String, Object> var3) throws AMQInvalidArgumentException;

    public QueueManagingVirtualHost<?> getVirtualHost();

    @DoOnConfigThread
    public boolean isBound(@Param(name="bindingKey") String var1, @Param(name="arguments") Map<String, Object> var2, @Param(name="queue") Queue<?> var3);

    @DoOnConfigThread
    public boolean isBound(@Param(name="bindingKey") String var1, @Param(name="queue") Queue<?> var2);

    @DoOnConfigThread
    public boolean isBound(@Param(name="bindingKey") String var1);

    @DoOnConfigThread
    public boolean hasBindings();

    @DoOnConfigThread
    public boolean isBound(@Param(name="queue") Queue<?> var1);

    @DoOnConfigThread
    public boolean isBound(@Param(name="arguments") Map<String, Object> var1);

    @DoOnConfigThread
    public boolean isBound(@Param(name="bindingKey") String var1, @Param(name="arguments") Map<String, Object> var2);

    @DoOnConfigThread
    public boolean isBound(@Param(name="arguments") Map<String, Object> var1, @Param(name="queue") Queue<?> var2);

    public EventLogger getEventLogger();

    public static enum BehaviourOnUnknownDeclareArgument {
        IGNORE,
        LOG,
        FAIL;

    }

    public static enum UnroutableMessageBehaviour {
        REJECT,
        DISCARD;

    }
}

