/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.LogUtils;
import java.nio.ByteBuffer;
import java.util.Random;

public class BINDeltaBloomFilter {
    private static final long FNVOffsetBasis = 2166136261L;
    private static final long FNVPrime = 16777619L;
    private static final int M_N_RATIO = 8;
    private static final int K = 3;

    public static void add(byte[] bf, byte[] key, HashContext hc) {
        BINDeltaBloomFilter.hash(bf, key, hc);
        for (int idx : hc.hashes) {
            BINDeltaBloomFilter.setBit(bf, idx);
        }
    }

    static boolean contains(byte[] bf, byte[] key) {
        HashContext hc = new HashContext();
        BINDeltaBloomFilter.hash(bf, key, hc);
        for (int idx : hc.hashes) {
            if (BINDeltaBloomFilter.getBit(bf, idx)) continue;
            return false;
        }
        return true;
    }

    private static void hash(byte[] bf, byte[] key, HashContext hc) {
        assert (hc.hashes.length == 3);
        hc.rng.setSeed(BINDeltaBloomFilter.hashFNV(key, hc.initFNVvalue));
        int numBits = bf.length * 8;
        if (numBits <= 1024) {
            int hash = hc.rng.nextInt();
            hc.hashes[0] = (hash & 0x3FF) % numBits;
            hc.hashes[1] = ((hash >>= 10) & 0x3FF) % numBits;
            hc.hashes[2] = ((hash >>= 10) & 0x3FF) % numBits;
        } else {
            hc.hashes[0] = (int)(((long)hc.rng.nextInt() & 0xFFFFFFFFL) % (long)numBits);
            hc.hashes[1] = (int)(((long)hc.rng.nextInt() & 0xFFFFFFFFL) % (long)numBits);
            hc.hashes[2] = (int)(((long)hc.rng.nextInt() & 0xFFFFFFFFL) % (long)numBits);
        }
    }

    private static long hashFNV(byte[] key, long initValue) {
        long hash = initValue;
        for (byte b : key) {
            hash = hash * 16777619L & 0xFFFFFFFFFFFFFFFFL;
            hash ^= (long)b;
        }
        return hash;
    }

    static int getMemorySize(byte[] bf) {
        return MemoryBudget.byteArraySize(bf.length);
    }

    public static int getByteSize(int numKeys) {
        assert (numKeys > 0);
        int nbits = numKeys * 8;
        return (nbits + 7) / 8;
    }

    public static int getLogSize(int numKeys) {
        int nbytes = BINDeltaBloomFilter.getByteSize(numKeys);
        return LogUtils.getPackedIntLogSize(nbytes) + nbytes;
    }

    public static int getLogSize(byte[] bf) {
        return LogUtils.getByteArrayLogSize(bf);
    }

    public static void writeToLog(byte[] bf, ByteBuffer buffer) {
        LogUtils.writeByteArray(buffer, bf);
    }

    public static byte[] readFromLog(ByteBuffer buffer, int entryVersion) {
        return LogUtils.readByteArray(buffer, false);
    }

    public static void dumpLog(byte[] bf, StringBuilder sb, boolean verbose) {
        int nbits = bf.length * 8;
        sb.append("<BloomFilter>");
        for (int i = 0; i < nbits; ++i) {
            sb.append(BINDeltaBloomFilter.getBit(bf, i) ? 1 : 0);
        }
        sb.append("</BloomFilter>");
    }

    public static String toString(byte[] bf) {
        StringBuilder sb = new StringBuilder();
        int nbits = bf.length * 8;
        for (int i = 0; i < nbits; ++i) {
            sb.append(BINDeltaBloomFilter.getBit(bf, i) ? 1 : 0);
        }
        return sb.toString();
    }

    private static void setBit(byte[] bf, int idx) {
        int n = idx / 8;
        bf[n] = (byte)(bf[n] | 1 << idx % 8);
    }

    private static boolean getBit(byte[] bf, int idx) {
        return (bf[idx / 8] & 1 << idx % 8) != 0;
    }

    public static class HashContext {
        public int[] hashes = new int[3];
        public Random rng = new Random();
        public long initFNVvalue = 2166136261L;

        void hashKeyPrefix(byte[] prefix) {
            this.initFNVvalue = BINDeltaBloomFilter.hashFNV(prefix, this.initFNVvalue);
        }
    }
}

