/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.impl.admin;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.MqClientAdmin;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.CommandCustomHeader;
import org.apache.rocketmq.remoting.RemotingClient;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;
import org.apache.rocketmq.remoting.protocol.admin.ConsumeStats;
import org.apache.rocketmq.remoting.protocol.admin.TopicStatsTable;
import org.apache.rocketmq.remoting.protocol.body.ClusterInfo;
import org.apache.rocketmq.remoting.protocol.body.ConsumeMessageDirectlyResult;
import org.apache.rocketmq.remoting.protocol.body.ConsumerConnection;
import org.apache.rocketmq.remoting.protocol.body.ConsumerRunningInfo;
import org.apache.rocketmq.remoting.protocol.body.GroupList;
import org.apache.rocketmq.remoting.protocol.body.QueryConsumeTimeSpanBody;
import org.apache.rocketmq.remoting.protocol.body.QuerySubscriptionResponseBody;
import org.apache.rocketmq.remoting.protocol.body.QueueTimeSpan;
import org.apache.rocketmq.remoting.protocol.body.ResetOffsetBody;
import org.apache.rocketmq.remoting.protocol.body.TopicList;
import org.apache.rocketmq.remoting.protocol.header.ConsumeMessageDirectlyResultRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.CreateTopicRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.DeleteSubscriptionGroupRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.DeleteTopicRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.GetConsumeStatsRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.GetConsumerConnectionListRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.GetConsumerRunningInfoRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.GetTopicStatsInfoRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.QueryConsumeTimeSpanRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.QueryMessageRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.QuerySubscriptionByConsumerRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.QueryTopicConsumeByWhoRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.QueryTopicsByConsumerRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.ResetOffsetRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.ViewMessageRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.namesrv.DeleteKVConfigRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.namesrv.DeleteTopicFromNamesrvRequestHeader;
import org.apache.rocketmq.remoting.protocol.heartbeat.SubscriptionData;
import org.apache.rocketmq.remoting.protocol.subscription.SubscriptionGroupConfig;

public class MqClientAdminImpl
implements MqClientAdmin {
    private static final Logger log = LoggerFactory.getLogger(MqClientAdminImpl.class);
    private final RemotingClient remotingClient;

    public MqClientAdminImpl(RemotingClient remotingClient) {
        this.remotingClient = remotingClient;
    }

    @Override
    public CompletableFuture<List<MessageExt>> queryMessage(String address, boolean uniqueKeyFlag, boolean decompressBody, QueryMessageRequestHeader requestHeader, long timeoutMillis) {
        CompletableFuture<List<MessageExt>> future = new CompletableFuture<List<MessageExt>>();
        RemotingCommand request = RemotingCommand.createRequestCommand((int)12, (CommandCustomHeader)requestHeader);
        request.addExtField("_UNIQUE_KEY_QUERY", String.valueOf(uniqueKeyFlag));
        this.remotingClient.invoke(address, request, timeoutMillis).thenAccept(response -> {
            if (response.getCode() == 0) {
                List wrappers = MessageDecoder.decodesBatch((ByteBuffer)ByteBuffer.wrap(response.getBody()), (boolean)true, (boolean)decompressBody, (boolean)true);
                future.complete(this.filterMessages(wrappers, requestHeader.getTopic(), requestHeader.getKey(), uniqueKeyFlag));
            } else if (response.getCode() == 22) {
                ArrayList wrappers = new ArrayList();
                future.complete(wrappers);
            } else {
                log.warn("queryMessage getResponseCommand failed, {} {}, header={}", new Object[]{response.getCode(), response.getRemark(), requestHeader});
                future.completeExceptionally(new MQClientException(response.getCode(), response.getRemark()));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<TopicStatsTable> getTopicStatsInfo(String address, GetTopicStatsInfoRequestHeader requestHeader, long timeoutMillis) {
        CompletableFuture<TopicStatsTable> future = new CompletableFuture<TopicStatsTable>();
        RemotingCommand request = RemotingCommand.createRequestCommand((int)202, (CommandCustomHeader)requestHeader);
        this.remotingClient.invoke(address, request, timeoutMillis).thenAccept(response -> {
            if (response.getCode() == 0) {
                TopicStatsTable topicStatsTable = (TopicStatsTable)TopicStatsTable.decode((byte[])response.getBody(), TopicStatsTable.class);
                future.complete(topicStatsTable);
            } else {
                log.warn("getTopicStatsInfo getResponseCommand failed, {} {}, header={}", new Object[]{response.getCode(), response.getRemark(), requestHeader});
                future.completeExceptionally(new MQClientException(response.getCode(), response.getRemark()));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<List<QueueTimeSpan>> queryConsumeTimeSpan(String address, QueryConsumeTimeSpanRequestHeader requestHeader, long timeoutMillis) {
        CompletableFuture<List<QueueTimeSpan>> future = new CompletableFuture<List<QueueTimeSpan>>();
        RemotingCommand request = RemotingCommand.createRequestCommand((int)303, (CommandCustomHeader)requestHeader);
        this.remotingClient.invoke(address, request, timeoutMillis).thenAccept(response -> {
            if (response.getCode() == 0) {
                QueryConsumeTimeSpanBody consumeTimeSpanBody = (QueryConsumeTimeSpanBody)GroupList.decode((byte[])response.getBody(), QueryConsumeTimeSpanBody.class);
                future.complete(consumeTimeSpanBody.getConsumeTimeSpanSet());
            } else {
                log.warn("queryConsumerTimeSpan getResponseCommand failed, {} {}, header={}", new Object[]{response.getCode(), response.getRemark(), requestHeader});
                future.completeExceptionally(new MQClientException(response.getCode(), response.getRemark()));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> updateOrCreateTopic(String address, CreateTopicRequestHeader requestHeader, long timeoutMillis) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        RemotingCommand request = RemotingCommand.createRequestCommand((int)17, (CommandCustomHeader)requestHeader);
        this.remotingClient.invoke(address, request, timeoutMillis).thenAccept(response -> {
            if (response.getCode() == 0) {
                future.complete(null);
            } else {
                log.warn("updateOrCreateTopic getResponseCommand failed, {} {}, header={}", new Object[]{response.getCode(), response.getRemark(), requestHeader});
                future.completeExceptionally(new MQClientException(response.getCode(), response.getRemark()));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> updateOrCreateSubscriptionGroup(String address, SubscriptionGroupConfig config, long timeoutMillis) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        RemotingCommand request = RemotingCommand.createRequestCommand((int)200, null);
        byte[] body = RemotingSerializable.encode((Object)config);
        request.setBody(body);
        this.remotingClient.invoke(address, request, timeoutMillis).thenAccept(response -> {
            if (response.getCode() == 0) {
                future.complete(null);
            } else {
                log.warn("updateOrCreateSubscriptionGroup getResponseCommand failed, {} {}, header={}", new Object[]{response.getCode(), response.getRemark(), config});
                future.completeExceptionally(new MQClientException(response.getCode(), response.getRemark()));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> deleteTopicInBroker(String address, DeleteTopicRequestHeader requestHeader, long timeoutMillis) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        RemotingCommand request = RemotingCommand.createRequestCommand((int)215, (CommandCustomHeader)requestHeader);
        this.remotingClient.invoke(address, request, timeoutMillis).thenAccept(response -> {
            if (response.getCode() == 0) {
                future.complete(null);
            } else {
                log.warn("deleteTopicInBroker getResponseCommand failed, {} {}, header={}", new Object[]{response.getCode(), response.getRemark(), requestHeader});
                future.completeExceptionally(new MQClientException(response.getCode(), response.getRemark()));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> deleteTopicInNameserver(String address, DeleteTopicFromNamesrvRequestHeader requestHeader, long timeoutMillis) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        RemotingCommand request = RemotingCommand.createRequestCommand((int)216, (CommandCustomHeader)requestHeader);
        this.remotingClient.invoke(address, request, timeoutMillis).thenAccept(response -> {
            if (response.getCode() == 0) {
                future.complete(null);
            } else {
                log.warn("deleteTopicInNameserver getResponseCommand failed, {} {}, header={}", new Object[]{response.getCode(), response.getRemark(), requestHeader});
                future.completeExceptionally(new MQClientException(response.getCode(), response.getRemark()));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> deleteKvConfig(String address, DeleteKVConfigRequestHeader requestHeader, long timeoutMillis) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        RemotingCommand request = RemotingCommand.createRequestCommand((int)102, (CommandCustomHeader)requestHeader);
        this.remotingClient.invoke(address, request, timeoutMillis).thenAccept(response -> {
            if (response.getCode() == 0) {
                future.complete(null);
            } else {
                log.warn("deleteKvConfig getResponseCommand failed, {} {}, header={}", new Object[]{response.getCode(), response.getRemark(), requestHeader});
                future.completeExceptionally(new MQClientException(response.getCode(), response.getRemark()));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> deleteSubscriptionGroup(String address, DeleteSubscriptionGroupRequestHeader requestHeader, long timeoutMillis) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        RemotingCommand request = RemotingCommand.createRequestCommand((int)207, (CommandCustomHeader)requestHeader);
        this.remotingClient.invoke(address, request, timeoutMillis).thenAccept(response -> {
            if (response.getCode() == 0) {
                future.complete(null);
            } else {
                log.warn("deleteSubscriptionGroup getResponseCommand failed, {} {}, header={}", new Object[]{response.getCode(), response.getRemark(), requestHeader});
                future.completeExceptionally(new MQClientException(response.getCode(), response.getRemark()));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Map<MessageQueue, Long>> invokeBrokerToResetOffset(String address, ResetOffsetRequestHeader requestHeader, long timeoutMillis) {
        CompletableFuture<Map<MessageQueue, Long>> future = new CompletableFuture<Map<MessageQueue, Long>>();
        RemotingCommand request = RemotingCommand.createRequestCommand((int)222, (CommandCustomHeader)requestHeader);
        this.remotingClient.invoke(address, request, timeoutMillis).thenAccept(response -> {
            if (response.getCode() == 0 && null != response.getBody()) {
                Map offsetTable = ((ResetOffsetBody)ResetOffsetBody.decode((byte[])response.getBody(), ResetOffsetBody.class)).getOffsetTable();
                future.complete(offsetTable);
                log.info("Invoke broker to reset offset success. address:{}, header:{}, offsetTable:{}", new Object[]{address, requestHeader, offsetTable});
            } else {
                log.warn("invokeBrokerToResetOffset getResponseCommand failed, {} {}, header={}", new Object[]{response.getCode(), response.getRemark(), requestHeader});
                future.completeExceptionally(new MQClientException(response.getCode(), response.getRemark()));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<MessageExt> viewMessage(String address, ViewMessageRequestHeader requestHeader, long timeoutMillis) {
        CompletableFuture<MessageExt> future = new CompletableFuture<MessageExt>();
        RemotingCommand request = RemotingCommand.createRequestCommand((int)33, (CommandCustomHeader)requestHeader);
        this.remotingClient.invoke(address, request, timeoutMillis).thenAccept(response -> {
            if (response.getCode() == 0) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(response.getBody());
                MessageExt messageExt = MessageDecoder.clientDecode((ByteBuffer)byteBuffer, (boolean)true);
                future.complete(messageExt);
            } else {
                log.warn("viewMessage getResponseCommand failed, {} {}, header={}", new Object[]{response.getCode(), response.getRemark(), requestHeader});
                future.completeExceptionally(new MQClientException(response.getCode(), response.getRemark()));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<ClusterInfo> getBrokerClusterInfo(String address, long timeoutMillis) {
        CompletableFuture<ClusterInfo> future = new CompletableFuture<ClusterInfo>();
        RemotingCommand request = RemotingCommand.createRequestCommand((int)106, null);
        this.remotingClient.invoke(address, request, timeoutMillis).thenAccept(response -> {
            if (response.getCode() == 0) {
                ClusterInfo clusterInfo = (ClusterInfo)ClusterInfo.decode((byte[])response.getBody(), ClusterInfo.class);
                future.complete(clusterInfo);
            } else {
                log.warn("getBrokerClusterInfo getResponseCommand failed, {} {}", (Object)response.getCode(), (Object)response.getRemark());
                future.completeExceptionally(new MQClientException(response.getCode(), response.getRemark()));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<ConsumerConnection> getConsumerConnectionList(String address, GetConsumerConnectionListRequestHeader requestHeader, long timeoutMillis) {
        CompletableFuture<ConsumerConnection> future = new CompletableFuture<ConsumerConnection>();
        RemotingCommand request = RemotingCommand.createRequestCommand((int)203, (CommandCustomHeader)requestHeader);
        this.remotingClient.invoke(address, request, timeoutMillis).thenAccept(response -> {
            if (response.getCode() == 0) {
                ConsumerConnection consumerConnection = (ConsumerConnection)ConsumerConnection.decode((byte[])response.getBody(), ConsumerConnection.class);
                future.complete(consumerConnection);
            } else {
                log.warn("getConsumerConnectionList getResponseCommand failed, {} {}", (Object)response.getCode(), (Object)response.getRemark());
                future.completeExceptionally(new MQClientException(response.getCode(), response.getRemark()));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<TopicList> queryTopicsByConsumer(String address, QueryTopicsByConsumerRequestHeader requestHeader, long timeoutMillis) {
        CompletableFuture<TopicList> future = new CompletableFuture<TopicList>();
        RemotingCommand request = RemotingCommand.createRequestCommand((int)343, (CommandCustomHeader)requestHeader);
        this.remotingClient.invoke(address, request, timeoutMillis).thenAccept(response -> {
            if (response.getCode() == 0) {
                TopicList topicList = (TopicList)TopicList.decode((byte[])response.getBody(), TopicList.class);
                future.complete(topicList);
            } else {
                log.warn("queryTopicsByConsumer getResponseCommand failed, {} {}", (Object)response.getCode(), (Object)response.getRemark());
                future.completeExceptionally(new MQClientException(response.getCode(), response.getRemark()));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<SubscriptionData> querySubscriptionByConsumer(String address, QuerySubscriptionByConsumerRequestHeader requestHeader, long timeoutMillis) {
        CompletableFuture<SubscriptionData> future = new CompletableFuture<SubscriptionData>();
        RemotingCommand request = RemotingCommand.createRequestCommand((int)345, (CommandCustomHeader)requestHeader);
        this.remotingClient.invoke(address, request, timeoutMillis).thenAccept(response -> {
            if (response.getCode() == 0) {
                QuerySubscriptionResponseBody subscriptionResponseBody = (QuerySubscriptionResponseBody)QuerySubscriptionResponseBody.decode((byte[])response.getBody(), QuerySubscriptionResponseBody.class);
                future.complete(subscriptionResponseBody.getSubscriptionData());
            } else {
                log.warn("querySubscriptionByConsumer getResponseCommand failed, {} {}", (Object)response.getCode(), (Object)response.getRemark());
                future.completeExceptionally(new MQClientException(response.getCode(), response.getRemark()));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<ConsumeStats> getConsumeStats(String address, GetConsumeStatsRequestHeader requestHeader, long timeoutMillis) {
        CompletableFuture<ConsumeStats> future = new CompletableFuture<ConsumeStats>();
        RemotingCommand request = RemotingCommand.createRequestCommand((int)208, (CommandCustomHeader)requestHeader);
        this.remotingClient.invoke(address, request, timeoutMillis).thenAccept(response -> {
            if (response.getCode() == 0) {
                ConsumeStats consumeStats = (ConsumeStats)ConsumeStats.decode((byte[])response.getBody(), ConsumeStats.class);
                future.complete(consumeStats);
            } else {
                log.warn("getConsumeStats getResponseCommand failed, {} {}", (Object)response.getCode(), (Object)response.getRemark());
                future.completeExceptionally(new MQClientException(response.getCode(), response.getRemark()));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<GroupList> queryTopicConsumeByWho(String address, QueryTopicConsumeByWhoRequestHeader requestHeader, long timeoutMillis) {
        CompletableFuture<GroupList> future = new CompletableFuture<GroupList>();
        RemotingCommand request = RemotingCommand.createRequestCommand((int)300, (CommandCustomHeader)requestHeader);
        this.remotingClient.invoke(address, request, timeoutMillis).thenAccept(response -> {
            if (response.getCode() == 0) {
                GroupList groupList = (GroupList)GroupList.decode((byte[])response.getBody(), GroupList.class);
                future.complete(groupList);
            } else {
                log.warn("queryTopicConsumeByWho getResponseCommand failed, {} {}", (Object)response.getCode(), (Object)response.getRemark());
                future.completeExceptionally(new MQClientException(response.getCode(), response.getRemark()));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<ConsumerRunningInfo> getConsumerRunningInfo(String address, GetConsumerRunningInfoRequestHeader requestHeader, long timeoutMillis) {
        CompletableFuture<ConsumerRunningInfo> future = new CompletableFuture<ConsumerRunningInfo>();
        RemotingCommand request = RemotingCommand.createRequestCommand((int)307, (CommandCustomHeader)requestHeader);
        this.remotingClient.invoke(address, request, timeoutMillis).thenAccept(response -> {
            if (response.getCode() == 0) {
                ConsumerRunningInfo info = (ConsumerRunningInfo)ConsumerRunningInfo.decode((byte[])response.getBody(), ConsumerRunningInfo.class);
                future.complete(info);
            } else {
                log.warn("getConsumerRunningInfo getResponseCommand failed, {} {}", (Object)response.getCode(), (Object)response.getRemark());
                future.completeExceptionally(new MQClientException(response.getCode(), response.getRemark()));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<ConsumeMessageDirectlyResult> consumeMessageDirectly(String address, ConsumeMessageDirectlyResultRequestHeader requestHeader, long timeoutMillis) {
        CompletableFuture<ConsumeMessageDirectlyResult> future = new CompletableFuture<ConsumeMessageDirectlyResult>();
        RemotingCommand request = RemotingCommand.createRequestCommand((int)309, (CommandCustomHeader)requestHeader);
        this.remotingClient.invoke(address, request, timeoutMillis).thenAccept(response -> {
            if (response.getCode() == 0) {
                ConsumeMessageDirectlyResult info = (ConsumeMessageDirectlyResult)ConsumeMessageDirectlyResult.decode((byte[])response.getBody(), ConsumeMessageDirectlyResult.class);
                future.complete(info);
            } else {
                log.warn("consumeMessageDirectly getResponseCommand failed, {} {}", (Object)response.getCode(), (Object)response.getRemark());
                future.completeExceptionally(new MQClientException(response.getCode(), response.getRemark()));
            }
        });
        return future;
    }

    private List<MessageExt> filterMessages(List<MessageExt> messageFoundList, String topic, String key, boolean uniqueKeyFlag) {
        ArrayList<MessageExt> matchedMessages = new ArrayList<MessageExt>();
        if (uniqueKeyFlag) {
            matchedMessages.addAll(messageFoundList.stream().filter(msg -> topic.equals(msg.getTopic())).filter(msg -> key.equals(msg.getMsgId())).collect(Collectors.toList()));
        } else {
            matchedMessages.addAll(messageFoundList.stream().filter(msg -> topic.equals(msg.getTopic())).filter(msg -> {
                boolean matched = false;
                if (StringUtils.isNotBlank((CharSequence)msg.getKeys())) {
                    String[] keyArray;
                    for (String s : keyArray = msg.getKeys().split(" ")) {
                        if (!key.equals(s)) continue;
                        matched = true;
                        break;
                    }
                }
                return matched;
            }).collect(Collectors.toList()));
        }
        return matchedMessages;
    }
}

