/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.file;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.rocketmq.tieredstore.common.AppendResult;
import org.apache.rocketmq.tieredstore.common.FileSegmentType;
import org.apache.rocketmq.tieredstore.metadata.MetadataStore;
import org.apache.rocketmq.tieredstore.metadata.entity.FileSegmentMetadata;
import org.apache.rocketmq.tieredstore.provider.FileSegment;
import org.apache.rocketmq.tieredstore.provider.FileSegmentFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlatAppendFile {
    protected static final Logger log = LoggerFactory.getLogger((String)"RocketmqTieredStore");
    public static final long GET_FILE_SIZE_ERROR = -1L;
    protected final String filePath;
    protected final FileSegmentType fileType;
    protected final MetadataStore metadataStore;
    protected final FileSegmentFactory fileSegmentFactory;
    protected final ReentrantReadWriteLock fileSegmentLock;
    protected final CopyOnWriteArrayList<FileSegment> fileSegmentTable;

    protected FlatAppendFile(FileSegmentFactory fileSegmentFactory, FileSegmentType fileType, String filePath) {
        this.fileType = fileType;
        this.filePath = filePath;
        this.metadataStore = fileSegmentFactory.getMetadataStore();
        this.fileSegmentFactory = fileSegmentFactory;
        this.fileSegmentLock = new ReentrantReadWriteLock();
        this.fileSegmentTable = new CopyOnWriteArrayList();
        this.recover();
        this.recoverFileSize();
    }

    public void recover() {
        ArrayList fileSegmentList = new ArrayList();
        this.metadataStore.iterateFileSegment(this.filePath, this.fileType, metadata -> {
            FileSegment fileSegment = this.fileSegmentFactory.createSegment(this.fileType, metadata.getPath(), metadata.getBaseOffset());
            fileSegment.initPosition(metadata.getSize());
            fileSegment.setMinTimestamp(metadata.getBeginTimestamp());
            fileSegment.setMaxTimestamp(metadata.getEndTimestamp());
            fileSegmentList.add(fileSegment);
        });
        this.fileSegmentTable.addAll(fileSegmentList.stream().sorted().collect(Collectors.toList()));
    }

    public long getFileCorrectSize(FileSegment fileSegment) {
        while (true) {
            long fileSize;
            if ((fileSize = fileSegment.getSize()) != -1L) {
                log.debug("FlatAppendFile get file correct size, filePath={} fileType={}, fileSize={}", new Object[]{fileSegment.getPath(), fileSegment.getFileType(), fileSize});
                return fileSize;
            }
            log.warn("FlatAppendFile get file correct size error, filePath={}, fileType={}", (Object)fileSegment.getPath(), (Object)fileSegment.getFileType());
            try {
                TimeUnit.MILLISECONDS.sleep(50L);
                continue;
            }
            catch (InterruptedException e) {
                log.warn("FlatAppendFile get file correct size interrupted", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public void recoverFileSize() {
        if (this.fileSegmentTable.isEmpty() || FileSegmentType.INDEX.equals((Object)this.fileType)) {
            return;
        }
        FileSegment fileSegment = this.fileSegmentTable.get(this.fileSegmentTable.size() - 1);
        long fileSize = this.getFileCorrectSize(fileSegment);
        if (fileSegment.getCommitPosition() != fileSize) {
            fileSegment.initPosition(fileSize);
            this.flushFileSegmentMeta(fileSegment);
            log.warn("FlatAppendFile last file size not correct, filePath: {}", (Object)this.filePath);
        }
    }

    public void initOffset(long offset) {
        if (this.fileSegmentTable.isEmpty()) {
            FileSegment fileSegment = this.fileSegmentFactory.createSegment(this.fileType, this.filePath, offset);
            fileSegment.initPosition(this.getFileCorrectSize(fileSegment));
            this.flushFileSegmentMeta(fileSegment);
            this.fileSegmentTable.add(fileSegment);
        }
    }

    public void flushFileSegmentMeta(FileSegment fileSegment) {
        FileSegmentMetadata metadata = this.metadataStore.getFileSegment(this.filePath, fileSegment.getFileType(), fileSegment.getBaseOffset());
        if (metadata == null) {
            metadata = new FileSegmentMetadata(this.filePath, fileSegment.getBaseOffset(), fileSegment.getFileType().getCode());
            metadata.setCreateTimestamp(System.currentTimeMillis());
        }
        metadata.setSize(fileSegment.getCommitPosition());
        metadata.setBeginTimestamp(fileSegment.getMinTimestamp());
        metadata.setEndTimestamp(fileSegment.getMaxTimestamp());
        this.metadataStore.updateFileSegment(metadata);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public FileSegmentType getFileType() {
        return this.fileType;
    }

    public List<FileSegment> getFileSegmentList() {
        return this.fileSegmentTable;
    }

    public long getMinOffset() {
        CopyOnWriteArrayList<FileSegment> list = this.fileSegmentTable;
        return list.isEmpty() ? 0L : ((FileSegment)list.get(0)).getBaseOffset();
    }

    public long getCommitOffset() {
        CopyOnWriteArrayList<FileSegment> list = this.fileSegmentTable;
        return list.isEmpty() ? 0L : ((FileSegment)list.get(list.size() - 1)).getCommitOffset();
    }

    public long getAppendOffset() {
        CopyOnWriteArrayList<FileSegment> list = this.fileSegmentTable;
        return list.isEmpty() ? 0L : ((FileSegment)list.get(list.size() - 1)).getAppendOffset();
    }

    public long getMinTimestamp() {
        CopyOnWriteArrayList<FileSegment> list = this.fileSegmentTable;
        return list.isEmpty() ? -1L : ((FileSegment)list.get(0)).getMinTimestamp();
    }

    public long getMaxTimestamp() {
        CopyOnWriteArrayList<FileSegment> list = this.fileSegmentTable;
        return list.isEmpty() ? -1L : ((FileSegment)list.get(list.size() - 1)).getMaxTimestamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSegment rollingNewFile(long offset) {
        FileSegment fileSegment;
        this.fileSegmentLock.writeLock().lock();
        try {
            fileSegment = this.fileSegmentFactory.createSegment(this.fileType, this.filePath, offset);
            this.flushFileSegmentMeta(fileSegment);
            this.fileSegmentTable.add(fileSegment);
        }
        finally {
            this.fileSegmentLock.writeLock().unlock();
        }
        return fileSegment;
    }

    public FileSegment getFileToWrite() {
        CopyOnWriteArrayList<FileSegment> fileSegmentList = this.fileSegmentTable;
        if (fileSegmentList.isEmpty()) {
            throw new IllegalStateException("Need to set base offset before create file segment");
        }
        return (FileSegment)fileSegmentList.get(fileSegmentList.size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppendResult append(ByteBuffer buffer, long timestamp) {
        AppendResult result;
        this.fileSegmentLock.writeLock().lock();
        try {
            FileSegment fileSegment = this.getFileToWrite();
            result = fileSegment.append(buffer, timestamp);
            if (result == AppendResult.FILE_FULL) {
                boolean commitResult = fileSegment.commitAsync().join();
                log.info("FlatAppendFile#append not successful for the file {} is full, commit result={}", (Object)fileSegment.getPath(), (Object)commitResult);
                if (commitResult) {
                    this.flushFileSegmentMeta(fileSegment);
                    AppendResult appendResult = this.rollingNewFile(this.getAppendOffset()).append(buffer, timestamp);
                    return appendResult;
                }
                AppendResult appendResult = AppendResult.UNKNOWN_ERROR;
                return appendResult;
            }
        }
        finally {
            this.fileSegmentLock.writeLock().unlock();
        }
        return result;
    }

    public CompletableFuture<Boolean> commitAsync() {
        CopyOnWriteArrayList<FileSegment> fileSegmentsList = this.fileSegmentTable;
        if (fileSegmentsList.isEmpty()) {
            return CompletableFuture.completedFuture(true);
        }
        FileSegment fileSegment = (FileSegment)fileSegmentsList.get(fileSegmentsList.size() - 1);
        return fileSegment.commitAsync().thenApply(success -> {
            if (success.booleanValue()) {
                this.flushFileSegmentMeta(fileSegment);
            }
            return success;
        });
    }

    public CompletableFuture<ByteBuffer> readAsync(long offset, int length) {
        FileSegment fileSegment2;
        int index;
        CopyOnWriteArrayList<FileSegment> fileSegmentList = this.fileSegmentTable;
        for (index = fileSegmentList.size() - 1; index >= 0 && ((FileSegment)fileSegmentList.get(index)).getBaseOffset() > offset; --index) {
        }
        FileSegment fileSegment1 = (FileSegment)fileSegmentList.get(index);
        FileSegment fileSegment = fileSegment2 = offset + (long)length > fileSegment1.getCommitOffset() && fileSegmentList.size() > index + 1 ? (FileSegment)fileSegmentList.get(index + 1) : null;
        if (fileSegment2 == null) {
            return fileSegment1.readAsync(offset - fileSegment1.getBaseOffset(), length);
        }
        int segment1Length = (int)(fileSegment1.getCommitOffset() - offset);
        return fileSegment1.readAsync(offset - fileSegment1.getBaseOffset(), segment1Length).thenCombine(fileSegment2.readAsync(0L, length - segment1Length), (buffer1, buffer2) -> {
            ByteBuffer buffer = ByteBuffer.allocate(buffer1.remaining() + buffer2.remaining());
            buffer.put((ByteBuffer)buffer1).put((ByteBuffer)buffer2);
            buffer.flip();
            return buffer;
        });
    }

    public void shutdown() {
        this.fileSegmentLock.writeLock().lock();
        try {
            this.fileSegmentTable.forEach(FileSegment::close);
        }
        finally {
            this.fileSegmentLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyExpiredFile(long expireTimestamp) {
        this.fileSegmentLock.writeLock().lock();
        try {
            while (!this.fileSegmentTable.isEmpty()) {
                FileSegment fileSegment = this.fileSegmentTable.get(0);
                if (fileSegment.getMaxTimestamp() != Long.MAX_VALUE && fileSegment.getMaxTimestamp() >= expireTimestamp) {
                    log.debug("FileSegment has not expired, filePath={}, fileType={}, offset={}, expireTimestamp={}, maxTimestamp={}", new Object[]{this.filePath, this.fileType, fileSegment.getBaseOffset(), expireTimestamp, fileSegment.getMaxTimestamp()});
                    break;
                }
                fileSegment.destroyFile();
                if (fileSegment.exists()) continue;
                this.fileSegmentTable.remove(0);
                this.metadataStore.deleteFileSegment(this.filePath, this.fileType, fileSegment.getBaseOffset());
            }
        }
        finally {
            this.fileSegmentLock.writeLock().unlock();
        }
    }

    public void destroy() {
        this.destroyExpiredFile(Long.MAX_VALUE);
    }
}

