/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.scalar;

import io.protostuff.OutputEx;
import io.protostuff.compiler.model.Field;
import io.protostuff.compiler.model.Type;
import io.protostuff.runtime.FieldSchema;
import java.io.IOException;
import org.apache.servicecomb.foundation.common.base.DynamicEnum;
import org.apache.servicecomb.foundation.common.utils.bean.Getter;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;
import org.apache.servicecomb.foundation.protobuf.internal.schema.EnumMeta;

public class EnumWriteSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor.getJavaType().isEnumType()) {
            return new EnumSchema(protoField, propertyDescriptor);
        }
        return new EnumSchema(protoField, propertyDescriptor);
    }

    private static class EnumSchema<T>
    extends EnumDynamicSchema<T> {
        protected final Getter<T, Object> getter;

        public EnumSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor);
            this.getter = (Getter)propertyDescriptor.getGetter();
        }

        @Override
        public final void getAndWriteTo(OutputEx output, T message) throws IOException {
            Object value = this.getter.get(message);
            if (value != null) {
                this.writeTo(output, value);
            }
        }
    }

    private static class EnumDynamicSchema<T>
    extends FieldSchema<T> {
        private final EnumMeta enumMeta;

        public EnumDynamicSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor.getJavaType());
            this.enumMeta = new EnumMeta(protoField, this.javaType);
        }

        protected final void numberWrite(OutputEx output, Number value) throws IOException {
            int enumValue = value.intValue();
            if (!this.enumMeta.containsValue(enumValue)) {
                throw new IllegalStateException(String.format("invalid enum value %d for proto %s, field=%s:%s", enumValue, this.protoField.getTypeName(), ((Type)this.protoField.getParent()).getCanonicalName(), this.protoField.getName()));
            }
            output.writeScalarInt32(this.tag, this.tagSize, enumValue);
        }

        protected final void stringWrite(OutputEx output, String enumName) throws IOException {
            Integer enumValue = this.enumMeta.getValueByName(enumName);
            if (enumValue == null) {
                throw new IllegalStateException(String.format("invalid enum name %s for proto %s, field=%s:%s", enumName, this.protoField.getTypeName(), ((Type)this.protoField.getParent()).getCanonicalName(), this.protoField.getName()));
            }
            output.writeScalarInt32(this.tag, this.tagSize, enumValue);
        }

        @Override
        public final void writeTo(OutputEx output, Object value) throws IOException {
            if (value instanceof Enum) {
                this.stringWrite(output, ((Enum)value).name());
                return;
            }
            if (value instanceof DynamicEnum) {
                this.writeTo(output, ((DynamicEnum)value).getValue());
                return;
            }
            if (value instanceof Number) {
                this.numberWrite(output, ((Number)value).intValue());
                return;
            }
            if (value instanceof String[]) {
                if (((String[])value).length == 0) {
                    return;
                }
                this.stringWrite(output, ((String[])value)[0]);
                return;
            }
            if (value instanceof String) {
                this.stringWrite(output, (String)value);
                return;
            }
            ProtoUtils.throwNotSupportWrite(this.protoField, value);
        }
    }
}

